/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ComponentGrid;
import com.datadog.api.client.v2.model.InputSchema;
import com.datadog.api.client.v2.model.Query;
import com.datadog.api.client.v2.model.Script;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"components", "description", "embeddedQueries", "inputSchema", "name", "rootInstanceName", "scripts", "tags"})
public class UpdateAppRequestDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPONENTS = "components";
    private List<ComponentGrid> components = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EMBEDDED_QUERIES = "embeddedQueries";
    private List<Query> embeddedQueries = null;
    public static final String JSON_PROPERTY_INPUT_SCHEMA = "inputSchema";
    private InputSchema inputSchema;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ROOT_INSTANCE_NAME = "rootInstanceName";
    private String rootInstanceName;
    public static final String JSON_PROPERTY_SCRIPTS = "scripts";
    private List<Script> scripts = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public UpdateAppRequestDataAttributes components(List<ComponentGrid> components) {
        this.components = components;
        for (ComponentGrid item : components) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UpdateAppRequestDataAttributes addComponentsItem(ComponentGrid componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentGrid>();
        }
        this.components.add(componentsItem);
        this.unparsed |= componentsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="components")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ComponentGrid> getComponents() {
        return this.components;
    }

    public void setComponents(List<ComponentGrid> components) {
        this.components = components;
    }

    public UpdateAppRequestDataAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateAppRequestDataAttributes embeddedQueries(List<Query> embeddedQueries) {
        this.embeddedQueries = embeddedQueries;
        for (Query item : embeddedQueries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UpdateAppRequestDataAttributes addEmbeddedQueriesItem(Query embeddedQueriesItem) {
        if (this.embeddedQueries == null) {
            this.embeddedQueries = new ArrayList<Query>();
        }
        this.embeddedQueries.add(embeddedQueriesItem);
        this.unparsed |= embeddedQueriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="embeddedQueries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Query> getEmbeddedQueries() {
        return this.embeddedQueries;
    }

    public void setEmbeddedQueries(List<Query> embeddedQueries) {
        this.embeddedQueries = embeddedQueries;
    }

    public UpdateAppRequestDataAttributes inputSchema(InputSchema inputSchema) {
        this.inputSchema = inputSchema;
        this.unparsed |= inputSchema.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="inputSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InputSchema getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(InputSchema inputSchema) {
        this.inputSchema = inputSchema;
    }

    public UpdateAppRequestDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateAppRequestDataAttributes rootInstanceName(String rootInstanceName) {
        this.rootInstanceName = rootInstanceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="rootInstanceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRootInstanceName() {
        return this.rootInstanceName;
    }

    public void setRootInstanceName(String rootInstanceName) {
        this.rootInstanceName = rootInstanceName;
    }

    public UpdateAppRequestDataAttributes scripts(List<Script> scripts) {
        this.scripts = scripts;
        for (Script item : scripts) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UpdateAppRequestDataAttributes addScriptsItem(Script scriptsItem) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<Script>();
        }
        this.scripts.add(scriptsItem);
        this.unparsed |= scriptsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="scripts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Script> getScripts() {
        return this.scripts;
    }

    public void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    public UpdateAppRequestDataAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UpdateAppRequestDataAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public UpdateAppRequestDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAppRequestDataAttributes updateAppRequestDataAttributes = (UpdateAppRequestDataAttributes)o;
        return Objects.equals(this.components, updateAppRequestDataAttributes.components) && Objects.equals(this.description, updateAppRequestDataAttributes.description) && Objects.equals(this.embeddedQueries, updateAppRequestDataAttributes.embeddedQueries) && Objects.equals(this.inputSchema, updateAppRequestDataAttributes.inputSchema) && Objects.equals(this.name, updateAppRequestDataAttributes.name) && Objects.equals(this.rootInstanceName, updateAppRequestDataAttributes.rootInstanceName) && Objects.equals(this.scripts, updateAppRequestDataAttributes.scripts) && Objects.equals(this.tags, updateAppRequestDataAttributes.tags) && Objects.equals(this.additionalProperties, updateAppRequestDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.description, this.embeddedQueries, this.inputSchema, this.name, this.rootInstanceName, this.scripts, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAppRequestDataAttributes {\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    embeddedQueries: ").append(this.toIndentedString(this.embeddedQueries)).append("\n");
        sb.append("    inputSchema: ").append(this.toIndentedString(this.inputSchema)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rootInstanceName: ").append(this.toIndentedString(this.rootInstanceName)).append("\n");
        sb.append("    scripts: ").append(this.toIndentedString(this.scripts)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

