/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.DashboardShareType;
import com.datadog.api.client.v1.model.SelectableTemplateVariableItems;
import com.datadog.api.client.v1.model.SharedDashboardInviteesItems;
import com.datadog.api.client.v1.model.SharedDashboardStatus;
import com.datadog.api.client.v1.model.SharedDashboardUpdateRequestGlobalTime;
import com.datadog.api.client.v1.model.ViewingPreferences;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"embeddable_domains", "expiration", "global_time", "global_time_selectable_enabled", "invitees", "selectable_template_vars", "share_list", "share_type", "status", "title", "viewing_preferences"})
public class SharedDashboardUpdateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EMBEDDABLE_DOMAINS = "embeddable_domains";
    private List<String> embeddableDomains = null;
    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private JsonNullable<OffsetDateTime> expiration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GLOBAL_TIME = "global_time";
    private JsonNullable<SharedDashboardUpdateRequestGlobalTime> globalTime = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GLOBAL_TIME_SELECTABLE_ENABLED = "global_time_selectable_enabled";
    private JsonNullable<Boolean> globalTimeSelectableEnabled = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INVITEES = "invitees";
    private List<SharedDashboardInviteesItems> invitees = null;
    public static final String JSON_PROPERTY_SELECTABLE_TEMPLATE_VARS = "selectable_template_vars";
    private JsonNullable<List<SelectableTemplateVariableItems>> selectableTemplateVars = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SHARE_LIST = "share_list";
    private JsonNullable<List<String>> shareList = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SHARE_TYPE = "share_type";
    private JsonNullable<DashboardShareType> shareType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private SharedDashboardStatus status;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_VIEWING_PREFERENCES = "viewing_preferences";
    private ViewingPreferences viewingPreferences;
    private Map<String, Object> additionalProperties;

    public SharedDashboardUpdateRequest embeddableDomains(List<String> embeddableDomains) {
        this.embeddableDomains = embeddableDomains;
        return this;
    }

    public SharedDashboardUpdateRequest addEmbeddableDomainsItem(String embeddableDomainsItem) {
        if (this.embeddableDomains == null) {
            this.embeddableDomains = new ArrayList<String>();
        }
        this.embeddableDomains.add(embeddableDomainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="embeddable_domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEmbeddableDomains() {
        return this.embeddableDomains;
    }

    public void setEmbeddableDomains(List<String> embeddableDomains) {
        this.embeddableDomains = embeddableDomains;
    }

    public SharedDashboardUpdateRequest expiration(OffsetDateTime expiration) {
        this.expiration = JsonNullable.of((Object)expiration);
        return this;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getExpiration() {
        return (OffsetDateTime)this.expiration.orElse(null);
    }

    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getExpiration_JsonNullable() {
        return this.expiration;
    }

    @JsonProperty(value="expiration")
    public void setExpiration_JsonNullable(JsonNullable<OffsetDateTime> expiration) {
        this.expiration = expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = JsonNullable.of((Object)expiration);
    }

    public SharedDashboardUpdateRequest globalTime(SharedDashboardUpdateRequestGlobalTime globalTime) {
        this.globalTime = JsonNullable.of((Object)globalTime);
        return this;
    }

    @Nullable
    @JsonIgnore
    public SharedDashboardUpdateRequestGlobalTime getGlobalTime() {
        return (SharedDashboardUpdateRequestGlobalTime)this.globalTime.orElse(null);
    }

    @JsonProperty(value="global_time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SharedDashboardUpdateRequestGlobalTime> getGlobalTime_JsonNullable() {
        return this.globalTime;
    }

    @JsonProperty(value="global_time")
    public void setGlobalTime_JsonNullable(JsonNullable<SharedDashboardUpdateRequestGlobalTime> globalTime) {
        this.globalTime = globalTime;
    }

    public void setGlobalTime(SharedDashboardUpdateRequestGlobalTime globalTime) {
        this.globalTime = JsonNullable.of((Object)globalTime);
    }

    public SharedDashboardUpdateRequest globalTimeSelectableEnabled(Boolean globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = JsonNullable.of((Object)globalTimeSelectableEnabled);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getGlobalTimeSelectableEnabled() {
        return (Boolean)this.globalTimeSelectableEnabled.orElse(null);
    }

    @JsonProperty(value="global_time_selectable_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getGlobalTimeSelectableEnabled_JsonNullable() {
        return this.globalTimeSelectableEnabled;
    }

    @JsonProperty(value="global_time_selectable_enabled")
    public void setGlobalTimeSelectableEnabled_JsonNullable(JsonNullable<Boolean> globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = globalTimeSelectableEnabled;
    }

    public void setGlobalTimeSelectableEnabled(Boolean globalTimeSelectableEnabled) {
        this.globalTimeSelectableEnabled = JsonNullable.of((Object)globalTimeSelectableEnabled);
    }

    public SharedDashboardUpdateRequest invitees(List<SharedDashboardInviteesItems> invitees) {
        this.invitees = invitees;
        for (SharedDashboardInviteesItems item : invitees) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SharedDashboardUpdateRequest addInviteesItem(SharedDashboardInviteesItems inviteesItem) {
        if (this.invitees == null) {
            this.invitees = new ArrayList<SharedDashboardInviteesItems>();
        }
        this.invitees.add(inviteesItem);
        this.unparsed |= inviteesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="invitees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SharedDashboardInviteesItems> getInvitees() {
        return this.invitees;
    }

    public void setInvitees(List<SharedDashboardInviteesItems> invitees) {
        this.invitees = invitees;
    }

    public SharedDashboardUpdateRequest selectableTemplateVars(List<SelectableTemplateVariableItems> selectableTemplateVars) {
        this.selectableTemplateVars = JsonNullable.of(selectableTemplateVars);
        return this;
    }

    public SharedDashboardUpdateRequest addSelectableTemplateVarsItem(SelectableTemplateVariableItems selectableTemplateVarsItem) {
        if (this.selectableTemplateVars == null || !this.selectableTemplateVars.isPresent()) {
            this.selectableTemplateVars = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.selectableTemplateVars.get()).add(selectableTemplateVarsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<SelectableTemplateVariableItems> getSelectableTemplateVars() {
        return (List)this.selectableTemplateVars.orElse(null);
    }

    @JsonProperty(value="selectable_template_vars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<SelectableTemplateVariableItems>> getSelectableTemplateVars_JsonNullable() {
        return this.selectableTemplateVars;
    }

    @JsonProperty(value="selectable_template_vars")
    public void setSelectableTemplateVars_JsonNullable(JsonNullable<List<SelectableTemplateVariableItems>> selectableTemplateVars) {
        this.selectableTemplateVars = selectableTemplateVars;
    }

    public void setSelectableTemplateVars(List<SelectableTemplateVariableItems> selectableTemplateVars) {
        this.selectableTemplateVars = JsonNullable.of(selectableTemplateVars);
    }

    public SharedDashboardUpdateRequest shareList(List<String> shareList) {
        this.shareList = JsonNullable.of(shareList);
        return this;
    }

    public SharedDashboardUpdateRequest addShareListItem(String shareListItem) {
        if (this.shareList == null || !this.shareList.isPresent()) {
            this.shareList = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.shareList.get()).add(shareListItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Deprecated
    @Nullable
    @JsonIgnore
    public List<String> getShareList() {
        return (List)this.shareList.orElse(null);
    }

    @Deprecated
    @JsonProperty(value="share_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getShareList_JsonNullable() {
        return this.shareList;
    }

    @JsonProperty(value="share_list")
    public void setShareList_JsonNullable(JsonNullable<List<String>> shareList) {
        this.shareList = shareList;
    }

    public void setShareList(List<String> shareList) {
        this.shareList = JsonNullable.of(shareList);
    }

    public SharedDashboardUpdateRequest shareType(DashboardShareType shareType) {
        this.shareType = JsonNullable.of((Object)shareType);
        return this;
    }

    @Nullable
    @JsonIgnore
    public DashboardShareType getShareType() {
        return (DashboardShareType)this.shareType.orElse(null);
    }

    @JsonProperty(value="share_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DashboardShareType> getShareType_JsonNullable() {
        return this.shareType;
    }

    @JsonProperty(value="share_type")
    public void setShareType_JsonNullable(JsonNullable<DashboardShareType> shareType) {
        this.shareType = shareType;
    }

    public void setShareType(DashboardShareType shareType) {
        if (!shareType.isValid()) {
            this.unparsed = true;
        }
        this.shareType = JsonNullable.of((Object)shareType);
    }

    public SharedDashboardUpdateRequest status(SharedDashboardStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SharedDashboardStatus getStatus() {
        return this.status;
    }

    public void setStatus(SharedDashboardStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SharedDashboardUpdateRequest title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SharedDashboardUpdateRequest viewingPreferences(ViewingPreferences viewingPreferences) {
        this.viewingPreferences = viewingPreferences;
        this.unparsed |= viewingPreferences.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="viewing_preferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViewingPreferences getViewingPreferences() {
        return this.viewingPreferences;
    }

    public void setViewingPreferences(ViewingPreferences viewingPreferences) {
        this.viewingPreferences = viewingPreferences;
    }

    @JsonAnySetter
    public SharedDashboardUpdateRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedDashboardUpdateRequest sharedDashboardUpdateRequest = (SharedDashboardUpdateRequest)o;
        return Objects.equals(this.embeddableDomains, sharedDashboardUpdateRequest.embeddableDomains) && Objects.equals(this.expiration, sharedDashboardUpdateRequest.expiration) && Objects.equals(this.globalTime, sharedDashboardUpdateRequest.globalTime) && Objects.equals(this.globalTimeSelectableEnabled, sharedDashboardUpdateRequest.globalTimeSelectableEnabled) && Objects.equals(this.invitees, sharedDashboardUpdateRequest.invitees) && Objects.equals(this.selectableTemplateVars, sharedDashboardUpdateRequest.selectableTemplateVars) && Objects.equals(this.shareList, sharedDashboardUpdateRequest.shareList) && Objects.equals(this.shareType, sharedDashboardUpdateRequest.shareType) && Objects.equals(this.status, sharedDashboardUpdateRequest.status) && Objects.equals(this.title, sharedDashboardUpdateRequest.title) && Objects.equals(this.viewingPreferences, sharedDashboardUpdateRequest.viewingPreferences) && Objects.equals(this.additionalProperties, sharedDashboardUpdateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.embeddableDomains, this.expiration, this.globalTime, this.globalTimeSelectableEnabled, this.invitees, this.selectableTemplateVars, this.shareList, this.shareType, this.status, this.title, this.viewingPreferences, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharedDashboardUpdateRequest {\n");
        sb.append("    embeddableDomains: ").append(this.toIndentedString(this.embeddableDomains)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    globalTime: ").append(this.toIndentedString(this.globalTime)).append("\n");
        sb.append("    globalTimeSelectableEnabled: ").append(this.toIndentedString(this.globalTimeSelectableEnabled)).append("\n");
        sb.append("    invitees: ").append(this.toIndentedString(this.invitees)).append("\n");
        sb.append("    selectableTemplateVars: ").append(this.toIndentedString(this.selectableTemplateVars)).append("\n");
        sb.append("    shareList: ").append(this.toIndentedString(this.shareList)).append("\n");
        sb.append("    shareType: ").append(this.toIndentedString(this.shareType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    viewingPreferences: ").append(this.toIndentedString(this.viewingPreferences)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

