/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetDeploymentFileOp;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"file_op", "file_path", "patch"})
public class FleetDeploymentOperation {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILE_OP = "file_op";
    private FleetDeploymentFileOp fileOp;
    public static final String JSON_PROPERTY_FILE_PATH = "file_path";
    private String filePath;
    public static final String JSON_PROPERTY_PATCH = "patch";
    private Map<String, Object> patch = null;
    private Map<String, Object> additionalProperties;

    public FleetDeploymentOperation() {
    }

    @JsonCreator
    public FleetDeploymentOperation(@JsonProperty(required=true, value="file_op") FleetDeploymentFileOp fileOp, @JsonProperty(required=true, value="file_path") String filePath) {
        this.fileOp = fileOp;
        this.unparsed |= !fileOp.isValid();
        this.filePath = filePath;
    }

    public FleetDeploymentOperation fileOp(FleetDeploymentFileOp fileOp) {
        this.fileOp = fileOp;
        this.unparsed |= !fileOp.isValid();
        return this;
    }

    @JsonProperty(value="file_op")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FleetDeploymentFileOp getFileOp() {
        return this.fileOp;
    }

    public void setFileOp(FleetDeploymentFileOp fileOp) {
        if (!fileOp.isValid()) {
            this.unparsed = true;
        }
        this.fileOp = fileOp;
    }

    public FleetDeploymentOperation filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @JsonProperty(value="file_path")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FleetDeploymentOperation patch(Map<String, Object> patch) {
        this.patch = patch;
        return this;
    }

    public FleetDeploymentOperation putPatchItem(String key, Object patchItem) {
        if (this.patch == null) {
            this.patch = new HashMap<String, Object>();
        }
        this.patch.put(key, patchItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="patch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getPatch() {
        return this.patch;
    }

    public void setPatch(Map<String, Object> patch) {
        this.patch = patch;
    }

    @JsonAnySetter
    public FleetDeploymentOperation putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetDeploymentOperation fleetDeploymentOperation = (FleetDeploymentOperation)o;
        return Objects.equals(this.fileOp, fleetDeploymentOperation.fileOp) && Objects.equals(this.filePath, fleetDeploymentOperation.filePath) && Objects.equals(this.patch, fleetDeploymentOperation.patch) && Objects.equals(this.additionalProperties, fleetDeploymentOperation.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fileOp, this.filePath, this.patch, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetDeploymentOperation {\n");
        sb.append("    fileOp: ").append(this.toIndentedString(this.fileOp)).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    patch: ").append(this.toIndentedString(this.patch)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

