/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.JsonTimeSerializer;
import com.datadog.api.client.v1.model.SyntheticsSSLCertificateIssuer;
import com.datadog.api.client.v1.model.SyntheticsSSLCertificateSubject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"cipher", "exponent", "extKeyUsage", "fingerprint", "fingerprint256", "issuer", "modulus", "protocol", "serialNumber", "subject", "validFrom", "validTo"})
public class SyntheticsSSLCertificate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CIPHER = "cipher";
    private String cipher;
    public static final String JSON_PROPERTY_EXPONENT = "exponent";
    private Double exponent;
    public static final String JSON_PROPERTY_EXT_KEY_USAGE = "extKeyUsage";
    private List<String> extKeyUsage = null;
    public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
    private String fingerprint;
    public static final String JSON_PROPERTY_FINGERPRINT256 = "fingerprint256";
    private String fingerprint256;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private SyntheticsSSLCertificateIssuer issuer;
    public static final String JSON_PROPERTY_MODULUS = "modulus";
    private String modulus;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private String protocol;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SyntheticsSSLCertificateSubject subject;
    public static final String JSON_PROPERTY_VALID_FROM = "validFrom";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime validFrom;
    public static final String JSON_PROPERTY_VALID_TO = "validTo";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime validTo;

    public SyntheticsSSLCertificate cipher(String cipher) {
        this.cipher = cipher;
        return this;
    }

    @Nullable
    @JsonProperty(value="cipher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCipher() {
        return this.cipher;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    public SyntheticsSSLCertificate exponent(Double exponent) {
        this.exponent = exponent;
        return this;
    }

    @Nullable
    @JsonProperty(value="exponent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getExponent() {
        return this.exponent;
    }

    public void setExponent(Double exponent) {
        this.exponent = exponent;
    }

    public SyntheticsSSLCertificate extKeyUsage(List<String> extKeyUsage) {
        this.extKeyUsage = extKeyUsage;
        return this;
    }

    public SyntheticsSSLCertificate addExtKeyUsageItem(String extKeyUsageItem) {
        if (this.extKeyUsage == null) {
            this.extKeyUsage = new ArrayList<String>();
        }
        this.extKeyUsage.add(extKeyUsageItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="extKeyUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExtKeyUsage() {
        return this.extKeyUsage;
    }

    public void setExtKeyUsage(List<String> extKeyUsage) {
        this.extKeyUsage = extKeyUsage;
    }

    public SyntheticsSSLCertificate fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @Nullable
    @JsonProperty(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public SyntheticsSSLCertificate fingerprint256(String fingerprint256) {
        this.fingerprint256 = fingerprint256;
        return this;
    }

    @Nullable
    @JsonProperty(value="fingerprint256")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFingerprint256() {
        return this.fingerprint256;
    }

    public void setFingerprint256(String fingerprint256) {
        this.fingerprint256 = fingerprint256;
    }

    public SyntheticsSSLCertificate issuer(SyntheticsSSLCertificateIssuer issuer) {
        this.issuer = issuer;
        this.unparsed |= issuer.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsSSLCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(SyntheticsSSLCertificateIssuer issuer) {
        this.issuer = issuer;
    }

    public SyntheticsSSLCertificate modulus(String modulus) {
        this.modulus = modulus;
        return this;
    }

    @Nullable
    @JsonProperty(value="modulus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModulus() {
        return this.modulus;
    }

    public void setModulus(String modulus) {
        this.modulus = modulus;
    }

    public SyntheticsSSLCertificate protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public SyntheticsSSLCertificate serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public SyntheticsSSLCertificate subject(SyntheticsSSLCertificateSubject subject) {
        this.subject = subject;
        this.unparsed |= subject.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsSSLCertificateSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SyntheticsSSLCertificateSubject subject) {
        this.subject = subject;
    }

    public SyntheticsSSLCertificate validFrom(OffsetDateTime validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    @Nullable
    @JsonProperty(value="validFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(OffsetDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public SyntheticsSSLCertificate validTo(OffsetDateTime validTo) {
        this.validTo = validTo;
        return this;
    }

    @Nullable
    @JsonProperty(value="validTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(OffsetDateTime validTo) {
        this.validTo = validTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsSSLCertificate syntheticsSslCertificate = (SyntheticsSSLCertificate)o;
        return Objects.equals(this.cipher, syntheticsSslCertificate.cipher) && Objects.equals(this.exponent, syntheticsSslCertificate.exponent) && Objects.equals(this.extKeyUsage, syntheticsSslCertificate.extKeyUsage) && Objects.equals(this.fingerprint, syntheticsSslCertificate.fingerprint) && Objects.equals(this.fingerprint256, syntheticsSslCertificate.fingerprint256) && Objects.equals(this.issuer, syntheticsSslCertificate.issuer) && Objects.equals(this.modulus, syntheticsSslCertificate.modulus) && Objects.equals(this.protocol, syntheticsSslCertificate.protocol) && Objects.equals(this.serialNumber, syntheticsSslCertificate.serialNumber) && Objects.equals(this.subject, syntheticsSslCertificate.subject) && Objects.equals(this.validFrom, syntheticsSslCertificate.validFrom) && Objects.equals(this.validTo, syntheticsSslCertificate.validTo);
    }

    public int hashCode() {
        return Objects.hash(this.cipher, this.exponent, this.extKeyUsage, this.fingerprint, this.fingerprint256, this.issuer, this.modulus, this.protocol, this.serialNumber, this.subject, this.validFrom, this.validTo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsSSLCertificate {\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    exponent: ").append(this.toIndentedString(this.exponent)).append("\n");
        sb.append("    extKeyUsage: ").append(this.toIndentedString(this.extKeyUsage)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    fingerprint256: ").append(this.toIndentedString(this.fingerprint256)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    modulus: ").append(this.toIndentedString(this.modulus)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    validFrom: ").append(this.toIndentedString(this.validFrom)).append("\n");
        sb.append("    validTo: ").append(this.toIndentedString(this.validTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

