/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.CustomMetric;
import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.MetricWriter;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import java.util.stream.Collectors;

class ExtensionMetricWriter
extends MetricWriter {
    private static StatsDClient client;
    private static ExtensionMetricWriter emw;

    public static ExtensionMetricWriter GetInstance() {
        if (null == emw) {
            emw = new ExtensionMetricWriter();
        }
        return emw;
    }

    private ExtensionMetricWriter() {
        if (null == client) {
            try {
                client = new NonBlockingStatsDClientBuilder().prefix("").hostname("127.0.0.1").port(8125).enableTelemetry(false).telemetryFlushInterval(0).build();
            }
            catch (Exception e) {
                DDLogger.getLoggerImpl().error("Could not create StatsDClient " + e.getMessage(), new Object[0]);
                client = null;
            }
        }
    }

    @Override
    public void write(CustomMetric cm) {
        if (null != client) {
            String tags = "";
            if (cm.getTags() != null) {
                tags = cm.getTags().entrySet().stream().map(entry -> ((String)entry.getKey()).toLowerCase() + ":" + entry.getValue().toString().toLowerCase()).collect(Collectors.joining(","));
            }
            client.distribution(cm.getName(), cm.getValue(), new String[]{tags});
        } else {
            DDLogger.getLoggerImpl().error("Could not write the metric because the client is null", new Object[0]);
        }
    }

    @Override
    public void flush() {
    }
}

