/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

class PersistedCustomMetric {
    @SerializedName(value="m")
    public String metric;
    @SerializedName(value="v")
    public Double value;
    @SerializedName(value="t")
    public ArrayList<String> tags;
    @SerializedName(value="e")
    public long eventTime;

    public PersistedCustomMetric(String m, double v, Map<String, Object> t, Date e) {
        long unixTime;
        this.metric = m;
        this.value = v;
        ArrayList tagsList = new ArrayList();
        if (t != null) {
            t.forEach((k, val) -> tagsList.add(String.format("%s:%s", k, val.toString())));
        }
        this.tags = tagsList;
        this.eventTime = unixTime = e.getTime() / 1000L;
    }

    public String toJsonString() {
        Gson g = new Gson();
        return g.toJson((Object)this);
    }
}

