/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.datadoghq.datadog_lambda_java.Headerable;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;

public class SQSHeaderable
implements Headerable {
    public static final String DATADOG_ATTRIBUTE_NAME = "_datadog";
    private static final Type HEADERS_GSON_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> headers;

    public SQSHeaderable(SQSEvent event) {
        if (event != null && event.getRecords() != null && !event.getRecords().isEmpty() && ((SQSEvent.SQSMessage)event.getRecords().get(0)).getMessageAttributes() != null && !((SQSEvent.SQSMessage)event.getRecords().get(0)).getMessageAttributes().isEmpty() && ((SQSEvent.SQSMessage)event.getRecords().get(0)).getMessageAttributes().get(DATADOG_ATTRIBUTE_NAME) != null) {
            String datadogAttribute = ((SQSEvent.MessageAttribute)((SQSEvent.SQSMessage)event.getRecords().get(0)).getMessageAttributes().get(DATADOG_ATTRIBUTE_NAME)).getStringValue();
            Gson g = new Gson();
            this.headers = (Map)g.fromJson(datadogAttribute, HEADERS_GSON_TYPE);
        } else {
            this.headers = Collections.emptyMap();
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

