/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.api.function.Function;
import java.util.concurrent.atomic.AtomicReference;

public interface WeakCache<K, V> {
    public V getIfPresent(K var1);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public void put(K var1, V var2);

    public static abstract class Supplier {
        private static final AtomicReference<Supplier> SUPPLIER = new AtomicReference();

        protected abstract <K, V> WeakCache<K, V> get(long var1);

        public static <K, V> WeakCache<K, V> newWeakCache(long maxSize) {
            return SUPPLIER.get().get(maxSize);
        }

        public static void registerIfAbsent(Supplier supplier) {
            SUPPLIER.compareAndSet(null, supplier);
        }
    }
}

