/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.PersonInfo;

class AzurePipelinesInfo
extends CIProviderInfo {
    public static final String AZURE = "TF_BUILD";
    public static final String AZURE_PROVIDER_NAME = "azurepipelines";
    public static final String AZURE_PIPELINE_NAME = "BUILD_DEFINITIONNAME";
    public static final String AZURE_SYSTEM_TEAMFOUNDATIONSERVERURI = "SYSTEM_TEAMFOUNDATIONSERVERURI";
    public static final String AZURE_SYSTEM_TEAMPROJECTID = "SYSTEM_TEAMPROJECTID";
    public static final String AZURE_SYSTEM_STAGEDISPLAYNAME = "SYSTEM_STAGEDISPLAYNAME";
    public static final String AZURE_SYSTEM_JOBDISPLAYNAME = "SYSTEM_JOBDISPLAYNAME";
    public static final String AZURE_BUILD_BUILDID = "BUILD_BUILDID";
    public static final String AZURE_SYSTEM_JOBID = "SYSTEM_JOBID";
    public static final String AZURE_SYSTEM_TASKINSTANCEID = "SYSTEM_TASKINSTANCEID";
    public static final String AZURE_WORKSPACE_PATH = "BUILD_SOURCESDIRECTORY";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI = "SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI";
    public static final String AZURE_BUILD_REPOSITORY_URI = "BUILD_REPOSITORY_URI";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCECOMMITID = "SYSTEM_PULLREQUEST_SOURCECOMMITID";
    public static final String AZURE_BUILD_SOURCEVERSION = "BUILD_SOURCEVERSION";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH = "SYSTEM_PULLREQUEST_SOURCEBRANCH";
    public static final String AZURE_BUILD_SOURCEBRANCH = "BUILD_SOURCEBRANCH";
    public static final String AZURE_BUILD_SOURCEVERSION_MESSAGE = "BUILD_SOURCEVERSIONMESSAGE";
    public static final String AZURE_BUILD_REQUESTED_FOR_ID = "BUILD_REQUESTEDFORID";
    public static final String AZURE_BUILD_REQUESTED_FOR_EMAIL = "BUILD_REQUESTEDFOREMAIL";

    AzurePipelinesInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        return new GitInfo(this.buildGitRepositoryUrl(), this.buildGitBranch(), this.buildGitTag(), new CommitInfo(this.buildGitCommit(), this.buildGitCommitAuthor(), PersonInfo.NOOP, System.getenv(AZURE_BUILD_SOURCEVERSION_MESSAGE)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        String uri = System.getenv(AZURE_SYSTEM_TEAMFOUNDATIONSERVERURI);
        String project = System.getenv(AZURE_SYSTEM_TEAMPROJECTID);
        String buildId = System.getenv(AZURE_BUILD_BUILDID);
        String jobId = System.getenv(AZURE_SYSTEM_JOBID);
        String taskId = System.getenv(AZURE_SYSTEM_TASKINSTANCEID);
        return CIProviderInfo.CIInfo.builder().ciProviderName(AZURE_PROVIDER_NAME).ciPipelineId(System.getenv(AZURE_BUILD_BUILDID)).ciPipelineName(System.getenv(AZURE_PIPELINE_NAME)).ciPipelineNumber(buildId).ciPipelineUrl(this.buildCiPipelineUrl(uri, project, buildId)).ciStageName(System.getenv(AZURE_SYSTEM_STAGEDISPLAYNAME)).ciJobName(System.getenv(AZURE_SYSTEM_JOBDISPLAYNAME)).ciJobUrl(this.buildCiJobUrl(uri, project, buildId, jobId, taskId)).ciWorkspace(this.expandTilde(System.getenv(AZURE_WORKSPACE_PATH))).build();
    }

    private String buildGitTag() {
        String branchOrTag = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH);
        if (branchOrTag == null || branchOrTag.isEmpty()) {
            branchOrTag = System.getenv(AZURE_BUILD_SOURCEBRANCH);
        }
        if (branchOrTag != null && branchOrTag.contains("tags")) {
            return this.normalizeRef(branchOrTag);
        }
        return null;
    }

    private String buildGitBranch() {
        String branchOrTag = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH);
        if (branchOrTag == null || branchOrTag.isEmpty()) {
            branchOrTag = System.getenv(AZURE_BUILD_SOURCEBRANCH);
        }
        if (branchOrTag != null && !branchOrTag.contains("tags")) {
            return this.normalizeRef(branchOrTag);
        }
        return null;
    }

    private String buildGitCommit() {
        String commit = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCECOMMITID);
        if (commit == null || commit.isEmpty()) {
            commit = System.getenv(AZURE_BUILD_SOURCEVERSION);
        }
        return commit;
    }

    private String buildGitRepositoryUrl() {
        String repoUrl = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI);
        if (repoUrl == null || repoUrl.isEmpty()) {
            repoUrl = System.getenv(AZURE_BUILD_REPOSITORY_URI);
        }
        return this.filterSensitiveInfo(repoUrl);
    }

    private String buildCiJobUrl(String uri, String project, String buildId, String jobId, String taskId) {
        return String.format("%s%s/_build/results?buildId=%s&view=logs&j=%s&t=%s", uri, project, buildId, jobId, taskId);
    }

    private String buildCiPipelineUrl(String uri, String project, String buildId) {
        return String.format("%s%s/_build/results?buildId=%s", uri, project, buildId);
    }

    private PersonInfo buildGitCommitAuthor() {
        return new PersonInfo(System.getenv(AZURE_BUILD_REQUESTED_FOR_ID), System.getenv(AZURE_BUILD_REQUESTED_FOR_EMAIL));
    }
}

