/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.function.BiFunction;
import datadog.trace.api.function.Function;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.function.TriFunction;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.IGSpanInfo;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.util.BitSet;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE, REQUEST_CARRIER>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    public static final String DD_DISPATCH_SPAN_ATTRIBUTE = "datadog.span.dispatch";
    public static final String DD_RESPONSE_ATTRIBUTE = "datadog.response";
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    protected static final UTF8BytesString NOT_FOUND_RESOURCE_NAME = UTF8BytesString.create("404");
    private static final boolean SHOULD_SET_404_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule") && Config.get().isRuleEnabled("Status404Rule") && Config.get().isRuleEnabled("Status404Decorator");
    private static final boolean SHOULD_SET_URL_RESOURCE_NAME = Config.get().isRuleEnabled("URLAsResourceNameRule");
    private static final BitSet SERVER_ERROR_STATUSES = Config.get().getHttpServerErrorStatuses();

    protected abstract AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter();

    protected abstract AgentPropagation.ContextVisitor<RESPONSE> responseGetter();

    public abstract CharSequence spanName();

    protected abstract String method(REQUEST var1);

    protected abstract URIDataAdapter url(REQUEST var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract int peerPort(CONNECTION var1);

    protected abstract int status(RESPONSE var1);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_SERVER;
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    protected AgentTracer.TracerAPI tracer() {
        return AgentTracer.get();
    }

    public AgentSpan.Context.Extracted extract(REQUEST_CARRIER carrier) {
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (null == carrier || null == getter) {
            return null;
        }
        return this.tracer().propagate().extract(carrier, getter);
    }

    public AgentSpan startSpan(REQUEST_CARRIER carrier, AgentSpan.Context.Extracted context) {
        AgentSpan span = this.tracer().startSpan(this.spanName(), this.callIGCallbackStart(context), true).setMeasured(true);
        this.callIGCallbackRequestHeaders(span, carrier);
        return span;
    }

    public AgentSpan onRequest(AgentSpan span, CONNECTION connection, REQUEST request, AgentSpan.Context.Extracted context) {
        if (context != null) {
            String forwardedPort;
            String forwardedIp;
            String forwardedHost;
            String forwardedProto;
            String forwarded = context.getForwarded();
            if (forwarded != null) {
                span.setTag("http.forwarded", forwarded);
            }
            if ((forwardedProto = context.getForwardedProto()) != null) {
                span.setTag("http.forwarded.proto", forwardedProto);
            }
            if ((forwardedHost = context.getForwardedHost()) != null) {
                span.setTag("http.forwarded.host", forwardedHost);
            }
            if ((forwardedIp = context.getForwardedIp()) != null) {
                span.setTag("http.forwarded.ip", forwardedIp);
            }
            if ((forwardedPort = context.getForwardedPort()) != null) {
                span.setTag("http.forwarded.port", forwardedPort);
            }
        }
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            try {
                URIDataAdapter url = this.url(request);
                if (url != null) {
                    Config config = Config.get();
                    boolean supportsRaw = url.supportsRaw();
                    boolean encoded = supportsRaw && config.isHttpServerRawResource();
                    String path = encoded ? url.rawPath() : url.path();
                    span.setTag("http.url", URIUtils.buildURL(url.scheme(), url.host(), url.port(), path));
                    if (context != null && context.getForwardedHost() != null) {
                        span.setTag("http.hostname", context.getForwardedHost());
                    } else if (url.host() != null) {
                        span.setTag("http.hostname", url.host());
                    }
                    if (config.isHttpServerTagQueryString()) {
                        String query = supportsRaw && config.isHttpServerRawQueryString() ? url.rawQuery() : url.query();
                        span.setTag("http.query.string", query);
                        span.setTag("http.fragment.string", url.fragment());
                    }
                    this.callIGCallbackURI(span, url, method);
                    if (SHOULD_SET_URL_RESOURCE_NAME) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withServerPath(span, method, path, encoded);
                    }
                } else if (SHOULD_SET_URL_RESOURCE_NAME) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        if (connection != null) {
            String ip = this.peerHostIP(connection);
            int port = this.peerPort(connection);
            if (ip != null) {
                if (ip.indexOf(58) > 0) {
                    span.setTag("peer.ipv6", ip);
                } else {
                    span.setTag("peer.ipv4", ip);
                }
            }
            this.setPeerPort(span, port);
            this.callIGCallbackSocketAddress(span, ip, port);
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            ResponseHeaderTagClassifier tagger;
            AgentPropagation.ContextVisitor<RESPONSE> getter;
            int status = this.status(response);
            if (status > 0) {
                span.setHttpStatusCode(status);
            }
            if (SERVER_ERROR_STATUSES.get(status)) {
                span.setError(true);
            }
            if (SHOULD_SET_404_RESOURCE_NAME && status == 404) {
                span.setResourceName(NOT_FOUND_RESOURCE_NAME, (byte)2);
            }
            if ((getter = this.responseGetter()) != null && (tagger = ResponseHeaderTagClassifier.create(span, Config.get().getResponseHeaderTags())) != null) {
                getter.forEachKey(response, tagger);
            }
            this.callIGCallbackResponseAndHeaders(span, response, status);
        }
        return span;
    }

    private AgentSpan.Context.Extracted callIGCallbackStart(AgentSpan.Context.Extracted context) {
        Object requestContextData;
        Supplier<Flow<Object>> startedCB;
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        if (null != cbp && null != (startedCB = cbp.getCallback(Events.EVENTS.requestStarted())) && null != (requestContextData = startedCB.get().getResult())) {
            TagContext tagContext = null;
            if (context == null) {
                tagContext = new TagContext();
            } else if (context instanceof TagContext) {
                tagContext = (TagContext)context;
            }
            if (null != tagContext) {
                context = tagContext.withRequestContextData(requestContextData);
            }
        }
        return context;
    }

    private void callIGCallbackRequestHeaders(AgentSpan span, REQUEST_CARRIER carrier) {
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        RequestContext<Object> requestContext = span.getRequestContext();
        AgentPropagation.ContextVisitor<REQUEST_CARRIER> getter = this.getter();
        if (requestContext == null || cbp == null || getter == null) {
            return;
        }
        IGKeyClassifier igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.requestHeader()), cbp.getCallback(Events.EVENTS.requestHeaderDone()));
        if (null != igKeyClassifier) {
            getter.forEachKey(carrier, igKeyClassifier);
            igKeyClassifier.done();
        }
    }

    private void callIGCallbackResponseAndHeaders(AgentSpan span, RESPONSE carrier, int status) {
        AgentPropagation.ContextVisitor<RESPONSE> getter;
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        RequestContext<Object> requestContext = span.getRequestContext();
        if (cbp == null || requestContext == null) {
            return;
        }
        BiFunction<RequestContext<Object>, Integer, Flow<Void>> addrCallback = cbp.getCallback(Events.EVENTS.responseStarted());
        if (null != addrCallback) {
            addrCallback.apply(requestContext, status);
        }
        if ((getter = this.responseGetter()) == null) {
            return;
        }
        IGKeyClassifier igKeyClassifier = IGKeyClassifier.create(requestContext, cbp.getCallback(Events.EVENTS.responseHeader()), cbp.getCallback(Events.EVENTS.responseHeaderDone()));
        if (null != igKeyClassifier) {
            getter.forEachKey(carrier, igKeyClassifier);
            igKeyClassifier.done();
        }
    }

    private void callIGCallbackURI(@Nonnull AgentSpan span, @Nonnull URIDataAdapter url, String method) {
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        RequestContext<Object> requestContext = span.getRequestContext();
        if (requestContext == null || cbp == null) {
            return;
        }
        TriFunction<RequestContext<Object>, String, URIDataAdapter, Flow<Void>> callback = cbp.getCallback(Events.EVENTS.requestMethodUriRaw());
        if (callback != null) {
            callback.apply(requestContext, method, url);
        }
    }

    @Override
    public AgentSpan beforeFinish(AgentSpan span) {
        this.onRequestEndForInstrumentationGateway(span);
        return super.beforeFinish(span);
    }

    private void onRequestEndForInstrumentationGateway(@Nonnull AgentSpan span) {
        BiFunction<RequestContext<Object>, IGSpanInfo, Flow<Void>> callback;
        if (span.getLocalRootSpan() != span) {
            return;
        }
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        RequestContext<Object> requestContext = span.getRequestContext();
        if (cbp != null && requestContext != null && (callback = cbp.getCallback(Events.EVENTS.requestEnded())) != null) {
            callback.apply(requestContext, span);
        }
    }

    private Flow<Void> callIGCallbackSocketAddress(@Nonnull AgentSpan span, @Nonnull String ip, int port) {
        TriFunction<RequestContext<Object>, String, Integer, Flow<Void>> addrCallback;
        InstrumentationGateway cbp = this.tracer().instrumentationGateway();
        if (cbp == null || ip == null && port == 0) {
            return Flow.ResultFlow.empty();
        }
        RequestContext<Object> ctx = span.getRequestContext();
        if (ctx != null && null != (addrCallback = cbp.getCallback(Events.EVENTS.requestClientSocketAddress()))) {
            return addrCallback.apply(ctx, ip != null ? ip : "0.0.0.0", port);
        }
        return Flow.ResultFlow.empty();
    }

    private static final class ResponseHeaderTagClassifier
    implements AgentPropagation.KeyClassifier {
        private final AgentSpan span;
        private final Map<String, String> headerTags;

        static final ResponseHeaderTagClassifier create(AgentSpan span, Map<String, String> headerTags) {
            if (span == null || headerTags == null || headerTags.isEmpty()) {
                return null;
            }
            return new ResponseHeaderTagClassifier(span, headerTags);
        }

        public ResponseHeaderTagClassifier(AgentSpan span, Map<String, String> headerTags) {
            this.span = span;
            this.headerTags = headerTags;
        }

        @Override
        public boolean accept(String key, String value) {
            String mappedKey = this.headerTags.get(key.toLowerCase());
            if (mappedKey != null) {
                this.span.setTag(mappedKey, value);
            }
            return true;
        }
    }

    private static final class IGKeyClassifier
    implements AgentPropagation.KeyClassifier {
        private final RequestContext<Object> requestContext;
        private final TriConsumer<RequestContext<Object>, String, String> headerCallback;
        private final Function<RequestContext<Object>, Flow<Void>> doneCallback;

        private static IGKeyClassifier create(RequestContext<Object> requestContext, TriConsumer<RequestContext<Object>, String, String> headerCallback, Function<RequestContext<Object>, Flow<Void>> doneCallback) {
            if (null == requestContext || null == headerCallback) {
                return null;
            }
            return new IGKeyClassifier(requestContext, headerCallback, doneCallback);
        }

        private IGKeyClassifier(RequestContext<Object> requestContext, TriConsumer<RequestContext<Object>, String, String> headerCallback, Function<RequestContext<Object>, Flow<Void>> doneCallback) {
            this.requestContext = requestContext;
            this.headerCallback = headerCallback;
            this.doneCallback = doneCallback;
        }

        @Override
        public boolean accept(String key, String value) {
            this.headerCallback.accept(this.requestContext, key, value);
            return true;
        }

        public void done() {
            if (null != this.doneCallback) {
                this.doneCallback.apply(this.requestContext);
            }
        }
    }
}

