/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ContinuationClaim;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ConcurrentState {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentState.class);
    public static ContextStore.Factory<ConcurrentState> FACTORY = new ContextStore.Factory<ConcurrentState>(){

        @Override
        public ConcurrentState create() {
            return new ConcurrentState();
        }
    };
    private volatile AgentScope.Continuation continuation = null;
    private static final AtomicReferenceFieldUpdater<ConcurrentState, AgentScope.Continuation> CONTINUATION = AtomicReferenceFieldUpdater.newUpdater(ConcurrentState.class, AgentScope.Continuation.class, "continuation");

    private ConcurrentState() {
    }

    public static <K> ConcurrentState captureScope(ContextStore<K, ConcurrentState> contextStore, K key, AgentScope scope) {
        if (scope != null && scope.isAsyncPropagating()) {
            if (scope.span() instanceof AgentTracer.NoopAgentSpan) {
                return null;
            }
            ConcurrentState state = contextStore.putIfAbsent(key, FACTORY);
            if (!state.captureAndSetContinuation(scope) && log.isDebugEnabled()) {
                log.debug("continuation was already set for {} in scope {}, no continuation captured.", (Object)key, (Object)scope);
            }
            return state;
        }
        return null;
    }

    public static <K> AgentScope activateAndContinueContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return null;
        }
        return state.activateAndContinueContinuation();
    }

    public static <K> void closeScope(ContextStore<K, ConcurrentState> contextStore, K key, AgentScope scope, Throwable throwable) {
        ConcurrentState state = contextStore.get(key);
        if (scope != null) {
            scope.close();
            return;
        }
        if (state == null) {
            return;
        }
        if (throwable != null) {
            state.closeContinuation();
        }
    }

    public static <K> void closeAndClearContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return;
        }
        state.closeAndClearContinuation();
    }

    private boolean captureAndSetContinuation(AgentScope scope) {
        if (CONTINUATION.compareAndSet(this, null, ContinuationClaim.CLAIMED)) {
            CONTINUATION.lazySet(this, scope.captureConcurrent());
            return true;
        }
        return false;
    }

    private AgentScope activateAndContinueContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            return continuation.activate();
        }
        return null;
    }

    private void closeContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            continuation.cancel();
        }
    }

    private void closeAndClearContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            CONTINUATION.compareAndSet(this, continuation, ContinuationClaim.CLAIMED);
            continuation.cancel();
        }
    }
}

