/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator.http;

import datadog.trace.api.Config;
import datadog.trace.api.Pair;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.function.Function;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.http.AntPatternPathNormalizer;
import datadog.trace.bootstrap.instrumentation.decorator.http.SimplePathNormalizer;

public class HttpResourceDecorator {
    public static final HttpResourceDecorator HTTP_RESOURCE_DECORATOR = new HttpResourceDecorator();
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    private static final Function<Pair<CharSequence, CharSequence>, UTF8BytesString> RESOURCE_NAME_JOINER = new Function<Pair<CharSequence, CharSequence>, UTF8BytesString>(){

        @Override
        public UTF8BytesString apply(Pair<CharSequence, CharSequence> input) {
            if (input.getLeft() == null) {
                return UTF8BytesString.create(input.getRight());
            }
            return UTF8BytesString.create(input.getLeft().toString().toUpperCase() + " " + input.getRight());
        }
    };
    private static final DDCache<Pair<CharSequence, CharSequence>, CharSequence> RESOURCE_NAME_CACHE = DDCaches.newFixedSizeCache(64);
    private final boolean shouldSetUrlResourceName = Config.get().isRuleEnabled("URLAsResourceNameRule");
    private final AntPatternPathNormalizer antPatternPathNormalizer = new AntPatternPathNormalizer(Config.get().getHttpServerPathResourceNameMapping());
    private final SimplePathNormalizer simplePathNormalizer = new SimplePathNormalizer();

    private HttpResourceDecorator() {
    }

    public final AgentSpan withClientPath(AgentSpan span, CharSequence method, CharSequence path) {
        span.setResourceName(RESOURCE_NAME_CACHE.computeIfAbsent(Pair.of(method, this.simplePathNormalizer.normalize(path.toString())), RESOURCE_NAME_JOINER), (byte)1);
        return span;
    }

    public final AgentSpan withServerPath(AgentSpan span, CharSequence method, CharSequence path, boolean encoded) {
        byte priority;
        if (!this.shouldSetUrlResourceName) {
            return span.setResourceName(DEFAULT_RESOURCE_NAME);
        }
        String resourcePath = this.antPatternPathNormalizer.normalize(path.toString(), encoded);
        if (resourcePath != null) {
            priority = 4;
        } else {
            resourcePath = this.simplePathNormalizer.normalize(path.toString(), encoded);
            priority = 1;
        }
        span.setResourceName(RESOURCE_NAME_CACHE.computeIfAbsent(Pair.of(method, resourcePath), RESOURCE_NAME_JOINER), priority);
        return span;
    }

    public final AgentSpan withRoute(AgentSpan span, CharSequence method, CharSequence route) {
        return this.withRoute(span, method, route, false);
    }

    public final AgentSpan withRoute(AgentSpan span, CharSequence method, CharSequence route, boolean encoded) {
        CharSequence routeTag = route;
        if (encoded) {
            routeTag = URIUtils.decode(route.toString());
        }
        span.setTag("http.route", routeTag);
        if (Config.get().isHttpServerRouteBasedNaming()) {
            CharSequence resourceName = RESOURCE_NAME_CACHE.computeIfAbsent(Pair.of(method, route), RESOURCE_NAME_JOINER);
            span.setResourceName(resourceName, (byte)3);
        }
        return span;
    }
}

