/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.exceptions;

import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Name(value="datadog.ExceptionSample")
@Label(value="ExceptionSample")
@Description(value="Datadog exception sample event.")
@Category(value={"Datadog"})
public class ExceptionSampleEvent
extends Event {
    @Label(value="Exception Type")
    private final String type;
    @Label(value="Exception message")
    private final String message;
    @Label(value="Exception stackdepth")
    private final int stackDepth;
    @Label(value="Sampled")
    private final boolean sampled;
    @Label(value="First occurrence")
    private final boolean firstOccurrence;

    public ExceptionSampleEvent(Throwable e, boolean sampled, boolean firstOccurrence) {
        this.type = e.getClass().getName();
        this.message = ExceptionSampleEvent.getMessage(e);
        this.stackDepth = ExceptionSampleEvent.getStackDepth(e);
        this.sampled = sampled;
        this.firstOccurrence = firstOccurrence;
    }

    private static String getMessage(Throwable t) {
        try {
            return t.getMessage();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int getStackDepth(Throwable t) {
        try {
            return t.getStackTrace().length;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

