/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging;

import datadog.slf4j.ILoggerFactory;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LogLevelSwitcher;

public class GlobalLogLevelSwitcher
implements LogLevelSwitcher {
    private static volatile LogLevelSwitcher INSTANCE = null;
    private final Logger log;
    private final LogLevelSwitcher delegate;

    public static LogLevelSwitcher get() {
        LogLevelSwitcher switcher = INSTANCE;
        if (switcher == null) {
            ILoggerFactory factory = LoggerFactory.getILoggerFactory();
            INSTANCE = switcher = new GlobalLogLevelSwitcher(factory);
        }
        return switcher;
    }

    GlobalLogLevelSwitcher(ILoggerFactory factory) {
        this.log = factory.getLogger(GlobalLogLevelSwitcher.class.getName());
        if (factory instanceof LogLevelSwitcher) {
            this.delegate = (LogLevelSwitcher)((Object)factory);
        } else {
            this.log.error("Unable to find global log level switcher, found {}", (Object)factory.getClass().getSimpleName());
            this.delegate = null;
        }
    }

    @Override
    public void switchLevel(LogLevel level) {
        if (this.delegate != null) {
            this.delegate.switchLevel(level);
        }
    }

    @Override
    public void restore() {
        if (this.delegate != null) {
            this.delegate.restore();
        }
    }
}

