/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.api.GenericClassValue;

public class CallDepthThreadLocalMap {
    private static final ClassValue<ThreadLocalDepth> TLS = GenericClassValue.constructing(ThreadLocalDepth.class);

    public static int incrementCallDepth(Class<?> k) {
        return ((Depth)CallDepthThreadLocalMap.TLS.get(k).get()).increment();
    }

    public static int decrementCallDepth(Class<?> k) {
        return ((Depth)CallDepthThreadLocalMap.TLS.get(k).get()).decrement();
    }

    public static void reset(Class<?> k) {
        ((Depth)TLS.get(k).get()).depth = 0;
    }

    public static final class ThreadLocalDepth
    extends ThreadLocal<Depth> {
        @Override
        protected Depth initialValue() {
            return new Depth();
        }
    }

    private static final class Depth {
        private int depth = 0;

        private Depth() {
        }

        private int increment() {
            return this.depth++;
        }

        private int decrement() {
            return --this.depth;
        }
    }
}

