/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import java.util.BitSet;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    public static final String DD_DISPATCH_SPAN_ATTRIBUTE = "datadog.span.dispatch";
    public static final String DD_RESPONSE_ATTRIBUTE = "datadog.response";
    private static final BitSet SERVER_ERROR_STATUSES = Config.get().getHttpServerErrorStatuses();
    public static final Integer _500 = RadixTreeCache.HTTP_STATUSES.get(500);

    protected abstract String method(REQUEST var1);

    protected abstract URIDataAdapter url(REQUEST var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract int peerPort(CONNECTION var1);

    protected abstract int status(RESPONSE var1);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_SERVER;
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    public AgentSpan onRequest(AgentSpan span, CONNECTION connection, REQUEST request, AgentSpan.Context.Extracted context) {
        if (context != null) {
            String forwardedPort;
            String forwardedIp;
            String forwardedHost;
            String forwardedProto;
            String forwarded = context.getForwarded();
            if (forwarded != null) {
                span.setTag("http.forwarded", forwarded);
            }
            if ((forwardedProto = context.getForwardedProto()) != null) {
                span.setTag("http.forwarded.proto", forwardedProto);
            }
            if ((forwardedHost = context.getForwardedHost()) != null) {
                span.setTag("http.forwarded.host", forwardedHost);
            }
            if ((forwardedIp = context.getForwardedIp()) != null) {
                span.setTag("http.forwarded.ip", forwardedIp);
            }
            if ((forwardedPort = context.getForwardedPort()) != null) {
                span.setTag("http.forwarded.port", forwardedPort);
            }
        }
        if (request != null) {
            span.setTag("http.method", this.method(request));
            try {
                URIDataAdapter url = this.url(request);
                if (url != null) {
                    span.setTag("http.url", HttpServerDecorator.buildURL(url));
                    if (Config.get().isHttpServerTagQueryString()) {
                        span.setTag("http.query.string", url.query());
                        span.setTag("http.fragment.string", url.fragment());
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        if (connection != null) {
            String ip = this.peerHostIP(connection);
            if (ip != null) {
                if (ip.indexOf(58) > 0) {
                    span.setTag("peer.ipv6", ip);
                } else {
                    span.setTag("peer.ipv4", ip);
                }
            }
            this.setPeerPort(span, this.peerPort(connection));
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            int status = this.status(response);
            if (status > 0) {
                span.setTag("http.status_code", RadixTreeCache.HTTP_STATUSES.get(status));
            }
            if (SERVER_ERROR_STATUSES.get(status)) {
                span.setError(true);
            }
        }
        return span;
    }

    private static String buildURL(URIDataAdapter uri) {
        String scheme = uri.scheme();
        String host = uri.host();
        String path = uri.path();
        int port = uri.port();
        int length = 0;
        length += null == scheme ? 0 : scheme.length() + 3;
        if (null != host) {
            length += host.length();
            if (port > 0 && port != 80 && port != 443) {
                length += 6;
            }
        }
        if (null == path || path.isEmpty()) {
            ++length;
        } else {
            if (path.charAt(0) != '/') {
                ++length;
            }
            length += path.length();
        }
        StringBuilder urlNoParams = new StringBuilder(length);
        if (scheme != null) {
            urlNoParams.append(scheme);
            urlNoParams.append("://");
        }
        if (host != null) {
            urlNoParams.append(host);
            if (port > 0 && port != 80 && port != 443) {
                urlNoParams.append(':');
                urlNoParams.append(port);
            }
        }
        if (null == path || path.isEmpty()) {
            urlNoParams.append('/');
        } else {
            if (path.charAt(0) != '/') {
                urlNoParams.append('/');
            }
            urlNoParams.append(path);
        }
        return urlNoParams.toString();
    }
}

