/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.EndpointCheckpointer;
import datadog.trace.api.EndpointTracker;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class EndpointCheckpointerHolder
implements EndpointCheckpointer {
    private static final Logger log = LoggerFactory.getLogger(EndpointCheckpointerHolder.class);
    private static final AtomicReferenceFieldUpdater<EndpointCheckpointerHolder, EndpointCheckpointer> ROOT_SPAN_CHECKPOINTER = AtomicReferenceFieldUpdater.newUpdater(EndpointCheckpointerHolder.class, EndpointCheckpointer.class, "endpointCheckpointer");
    private volatile EndpointCheckpointer endpointCheckpointer;

    public static EndpointCheckpointerHolder create() {
        return new EndpointCheckpointerHolder(NoOpCheckpointer.NO_OP);
    }

    public EndpointCheckpointerHolder(EndpointCheckpointer endpointCheckpointer) {
        this.endpointCheckpointer = endpointCheckpointer;
    }

    public void register(EndpointCheckpointer endpointCheckpointer) {
        if (!ROOT_SPAN_CHECKPOINTER.compareAndSet(this, NoOpCheckpointer.NO_OP, endpointCheckpointer)) {
            log.debug("failed to register root span checkpointer {} - {} already registered", (Object)endpointCheckpointer.getClass(), (Object)this.endpointCheckpointer.getClass());
        } else {
            log.debug("Registered root span checkpointer implementation: {}", (Object)endpointCheckpointer);
        }
    }

    @Override
    public void onRootSpanFinished(AgentSpan rootSpan, EndpointTracker tracker) {
        this.endpointCheckpointer.onRootSpanFinished(rootSpan, tracker);
    }

    @Override
    public EndpointTracker onRootSpanStarted(AgentSpan root) {
        return this.endpointCheckpointer.onRootSpanStarted(root);
    }

    private static final class NoOpCheckpointer
    implements EndpointCheckpointer {
        static final NoOpCheckpointer NO_OP = new NoOpCheckpointer();

        private NoOpCheckpointer() {
        }

        @Override
        public void onRootSpanFinished(AgentSpan rootSpan, EndpointTracker tracker) {
        }

        @Override
        public EndpointTracker onRootSpanStarted(AgentSpan rootSpan) {
            return null;
        }
    }
}

