/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class IntegrationsCollector {
    private static final Queue<Integration> integrations = new LinkedBlockingQueue<Integration>();

    public static IntegrationsCollector get() {
        return Holder.INSTANCE;
    }

    public synchronized void update(Iterable<String> names, boolean enabled) {
        Integration i = new Integration();
        i.names = names;
        i.enabled = enabled;
        integrations.offer(i);
    }

    public synchronized Map<String, Boolean> drain() {
        Integration i;
        if (integrations.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        while ((i = integrations.poll()) != null) {
            boolean enabled = i.enabled;
            for (String name : i.names) {
                map.put(name, enabled);
            }
        }
        return map;
    }

    protected static class Integration {
        public Iterable<String> names;
        public boolean enabled;

        protected Integration() {
        }
    }

    public static class Holder {
        public static final IntegrationsCollector INSTANCE = new IntegrationsCollector();
    }
}

