/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.git.CommitInfo;
import datadog.trace.api.git.EmbeddedGitInfoBuilder;
import datadog.trace.api.git.GitInfo;
import datadog.trace.api.git.GitInfoBuilder;
import datadog.trace.api.git.GitUtils;
import datadog.trace.api.git.PersonInfo;
import datadog.trace.api.git.UserSuppliedGitInfoBuilder;
import datadog.trace.util.Strings;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GitInfoProvider {
    public static final GitInfoProvider INSTANCE = new GitInfoProvider();
    private volatile Collection<GitInfoBuilder> builders = Collections.emptyList();
    private final DDCache<String, GitInfo> gitInfoCache = DDCaches.newFixedSizeCache(4);

    public GitInfo getGitInfo() {
        return this.getGitInfo(null);
    }

    public GitInfo getGitInfo(@Nullable String repositoryPath) {
        if (repositoryPath == null) {
            repositoryPath = Paths.get("", new String[0]).toAbsolutePath().toString();
        }
        return this.gitInfoCache.computeIfAbsent(repositoryPath, this::buildGitInfo);
    }

    private GitInfo buildGitInfo(String repositoryPath) {
        List<GitInfo> infos = this.builders.stream().map(builder -> builder.build(repositoryPath)).collect(Collectors.toList());
        String commitSha = GitInfoProvider.firstNonBlank(infos, gi -> gi.getCommit().getSha());
        return new GitInfo(GitInfoProvider.firstNonBlank(infos, gi -> GitUtils.filterSensitiveInfo(gi.getRepositoryURL())), GitInfoProvider.firstNonBlank(infos, GitInfo::getBranch), GitInfoProvider.firstNonBlank(infos, GitInfo::getTag), new CommitInfo(commitSha, new PersonInfo(GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getName()), GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getEmail()), GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getIso8601Date())), new PersonInfo(GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getName()), GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getEmail()), GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getIso8601Date())), GitInfoProvider.firstNonBlankWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getFullMessage())));
    }

    private static String firstNonBlank(Iterable<GitInfo> gitInfos, Function<GitInfo, String> function) {
        for (GitInfo gitInfo : gitInfos) {
            String result = function.apply(gitInfo);
            if (!Strings.isNotBlank(result)) continue;
            return result;
        }
        return null;
    }

    private static String firstNonBlankWithMatchingCommit(Iterable<GitInfo> gitInfos, String commitSha, Function<GitInfo, String> function) {
        for (GitInfo gitInfo : gitInfos) {
            String result;
            if (commitSha != null && !commitSha.equalsIgnoreCase(gitInfo.getCommit().getSha()) || !Strings.isNotBlank(result = function.apply(gitInfo))) continue;
            return result;
        }
        return null;
    }

    public synchronized void registerGitInfoBuilder(GitInfoBuilder builder) {
        ArrayList<GitInfoBuilder> updatedBuilders = new ArrayList<GitInfoBuilder>(this.builders);
        updatedBuilders.add(builder);
        updatedBuilders.sort(Comparator.comparingInt(GitInfoBuilder::order));
        this.builders = updatedBuilders;
        this.gitInfoCache.clear();
    }

    static {
        INSTANCE.registerGitInfoBuilder(new UserSuppliedGitInfoBuilder());
        INSTANCE.registerGitInfoBuilder(new EmbeddedGitInfoBuilder());
    }
}

