/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast.telemetry;

import datadog.trace.api.iast.telemetry.IastMetric;
import datadog.trace.api.iast.telemetry.IastTelemetryCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public interface IastMetricHandler {
    public boolean add(long var1, String var3);

    public boolean merge(IastTelemetryCollector.MetricData var1);

    public Collection<IastTelemetryCollector.MetricData> drain();

    public static IastMetricHandler delegating(IastMetric metric, IastTelemetryCollector collector) {
        return new DelegatingHandler(metric, collector);
    }

    public static IastMetricHandler conflated(IastMetric metric) {
        return metric.getTag() == null ? new DefaultHandler(metric, new ConflatedCombiner()) : new TaggedHandler(metric, ConflatedCombiner::new);
    }

    public static IastMetricHandler aggregated(IastMetric metric) {
        return metric.getTag() == null ? new DefaultHandler(metric, new AggregatedCombiner()) : new TaggedHandler(metric, AggregatedCombiner::new);
    }

    public static class AggregatedCombiner
    implements Combiner {
        private static final int DEFAULT_MAX_SIZE = 100;
        private final Queue<IastTelemetryCollector.Point> value;

        public AggregatedCombiner() {
            this(100);
        }

        public AggregatedCombiner(int maxSize) {
            this.value = new ArrayBlockingQueue<IastTelemetryCollector.Point>(maxSize);
        }

        @Override
        public boolean add(long value) {
            return this.value.offer(new IastTelemetryCollector.Point(value));
        }

        @Override
        public boolean merge(IastTelemetryCollector.MetricData metric) {
            boolean result = true;
            for (IastTelemetryCollector.Point point : metric.getPoints()) {
                result &= this.value.offer(point);
            }
            return result;
        }

        @Override
        public List<IastTelemetryCollector.Point> drain() {
            if (this.value.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IastTelemetryCollector.Point> points = new ArrayList<IastTelemetryCollector.Point>(this.value);
            this.value.clear();
            return points;
        }
    }

    public static class ConflatedCombiner
    implements Combiner {
        private final AtomicLong value = new AtomicLong(0L);

        @Override
        public boolean add(long value) {
            this.value.addAndGet(value);
            return true;
        }

        @Override
        public boolean merge(IastTelemetryCollector.MetricData metric) {
            long total = metric.getPoints().stream().mapToLong(IastTelemetryCollector.Point::getValue).sum();
            this.value.addAndGet(total);
            return true;
        }

        @Override
        public List<IastTelemetryCollector.Point> drain() {
            long prev = this.value.getAndSet(0L);
            return prev == 0L ? Collections.emptyList() : Collections.singletonList(new IastTelemetryCollector.Point(prev));
        }
    }

    public static interface Combiner {
        public boolean add(long var1);

        public boolean merge(IastTelemetryCollector.MetricData var1);

        public List<IastTelemetryCollector.Point> drain();
    }

    public static class TaggedHandler
    implements IastMetricHandler {
        private static final String EMPTY_TAG = "";
        private final IastMetric metric;
        private final Supplier<Combiner> supplier;
        private final ConcurrentHashMap<String, Combiner> map;

        public TaggedHandler(IastMetric metric, Supplier<Combiner> supplier) {
            this.metric = metric;
            this.supplier = supplier;
            this.map = new ConcurrentHashMap();
        }

        @Override
        public boolean add(long value, String tag) {
            return this.getOrCreateCombiner(tag).add(value);
        }

        @Override
        public boolean merge(IastTelemetryCollector.MetricData metric) {
            return this.getOrCreateCombiner(metric.getTag()).merge(metric);
        }

        private Combiner getOrCreateCombiner(String tag) {
            String key = tag == null ? EMPTY_TAG : tag;
            Combiner combiner = this.map.get(key);
            if (combiner == null) {
                combiner = this.supplier.get();
                Combiner old = this.map.putIfAbsent(key, combiner);
                combiner = old == null ? combiner : old;
            }
            return combiner;
        }

        @Override
        public Collection<IastTelemetryCollector.MetricData> drain() {
            if (this.map.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedList<IastTelemetryCollector.MetricData> values = new LinkedList<IastTelemetryCollector.MetricData>();
            for (Map.Entry<String, Combiner> entry : this.map.entrySet()) {
                List<IastTelemetryCollector.Point> points = entry.getValue().drain();
                if (points.isEmpty()) continue;
                values.add(new IastTelemetryCollector.MetricData(this.metric, entry.getKey(), points));
            }
            this.map.clear();
            return values;
        }
    }

    public static class DefaultHandler
    implements IastMetricHandler {
        private final IastMetric metric;
        private final Combiner combiner;

        public DefaultHandler(IastMetric metric, Combiner combiner) {
            this.metric = metric;
            this.combiner = combiner;
        }

        @Override
        public boolean add(long value, String tag) {
            return this.combiner.add(value);
        }

        @Override
        public boolean merge(IastTelemetryCollector.MetricData metric) {
            return this.combiner.merge(metric);
        }

        @Override
        public Collection<IastTelemetryCollector.MetricData> drain() {
            List<IastTelemetryCollector.Point> points = this.combiner.drain();
            return points.isEmpty() ? Collections.emptyList() : Collections.singletonList(new IastTelemetryCollector.MetricData(this.metric, points));
        }
    }

    public static class DelegatingHandler
    implements IastMetricHandler {
        private final IastMetric metric;
        private final IastTelemetryCollector collector;

        public DelegatingHandler(IastMetric metric, IastTelemetryCollector collector) {
            this.metric = metric;
            this.collector = collector;
        }

        @Override
        public boolean add(long value, String tag) {
            return this.collector.addMetric(this.metric, value, tag);
        }

        @Override
        public boolean merge(IastTelemetryCollector.MetricData metric) {
            return true;
        }

        @Override
        public Collection<IastTelemetryCollector.MetricData> drain() {
            return Collections.emptyList();
        }
    }
}

