/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.bootstrap.AgentJar;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AgentBootstrap {
    private static final Class<?> thisClass = AgentBootstrap.class;
    private static final int MAX_EXCEPTION_CHAIN_LENGTH = 99;
    private static boolean initialized = false;

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentBootstrap.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        if (AgentBootstrap.checkAndLogIfInitializedTwice(System.out)) {
            return;
        }
        if (AgentBootstrap.checkAndLogIfLessThanJava8()) {
            return;
        }
        try {
            URL agentJarURL = AgentBootstrap.installAgentJar(inst);
            Class<?> agentClass = Class.forName("datadog.trace.bootstrap.Agent", true, null);
            if (agentClass.getClassLoader() != null) {
                throw new IllegalStateException("DD Java Agent NOT added to bootstrap classpath.");
            }
            Method startMethod = agentClass.getMethod("start", Instrumentation.class, URL.class, String.class);
            startMethod.invoke(null, inst, agentJarURL, agentArgs);
        }
        catch (Throwable ex) {
            if (AgentBootstrap.exceptionCauseChainContains(ex, "datadog.trace.util.throwable.FatalAgentMisconfigurationError")) {
                throw new Error(ex);
            }
            System.err.println("ERROR " + thisClass.getName());
            ex.printStackTrace();
        }
    }

    static boolean exceptionCauseChainContains(Throwable ex, String exClassName) {
        Set stack = Collections.newSetFromMap(new IdentityHashMap());
        for (Throwable t = ex; t != null && stack.add(t) && stack.size() <= 99; t = t.getCause()) {
            if (!t.getClass().getName().equals(exClassName)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAndLogIfLessThanJava8() {
        return AgentBootstrap.checkAndLogIfLessThanJava8(System.getProperty("java.version"), System.out);
    }

    static boolean checkAndLogIfLessThanJava8(String version, PrintStream output) {
        if (AgentBootstrap.parseJavaMajorVersion(version) < 8) {
            String agentVersion = "This version";
            try {
                agentVersion = AgentJar.getAgentVersion();
                agentVersion = "Version " + agentVersion;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            output.println("Warning: " + agentVersion + " of dd-java-agent is not compatible with Java " + version + " and will not be installed.");
            output.println("Please upgrade your Java version to 8+ or use the 0.x version of dd-java-agent in your build tool or download it from https://dtdg.co/java-tracer-v0");
            return true;
        }
        return false;
    }

    static boolean checkAndLogIfInitializedTwice(PrintStream output) {
        if (initialized) {
            output.println("Warning: dd-java-agent is being initialized more than once. Please, check that you are defining -javaagent:dd-java-agent.jar only once.");
            return true;
        }
        initialized = true;
        return false;
    }

    static int parseJavaMajorVersion(String version) {
        char c;
        int major = 0;
        if (null == version || version.isEmpty()) {
            return major;
        }
        int start = 0;
        if (version.charAt(0) == '1' && version.length() >= 3 && version.charAt(1) == '.' && Character.isDigit(version.charAt(2))) {
            start = 2;
        }
        for (int i = start; i < version.length() && Character.isDigit(c = version.charAt(i)); ++i) {
            major *= 10;
            major += Character.digit(c, 10);
        }
        return major;
    }

    public static void main(String[] args) {
        if (AgentBootstrap.checkAndLogIfLessThanJava8()) {
            return;
        }
        AgentJar.main(args);
    }

    private static synchronized URL installAgentJar(Instrumentation inst) throws IOException, URISyntaxException {
        File ddJavaAgentJarPath;
        URL ddJavaAgentJarURL = null;
        CodeSource codeSource = thisClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && (ddJavaAgentJarURL = codeSource.getLocation()) != null && !(ddJavaAgentJarPath = new File(ddJavaAgentJarURL.toURI())).isDirectory()) {
            AgentBootstrap.checkJarManifestMainClassIsThis(ddJavaAgentJarURL);
            inst.appendToBootstrapClassLoaderSearch(new JarFile(ddJavaAgentJarPath));
            return ddJavaAgentJarURL;
        }
        System.out.println("Could not get bootstrap jar from code source, using -javaagent arg");
        List<String> arguments = AgentBootstrap.getVMArgumentsThroughReflection();
        String agentArgument = null;
        for (String arg : arguments) {
            if (!arg.startsWith("-javaagent")) continue;
            if (agentArgument == null) {
                agentArgument = arg;
                continue;
            }
            throw new IllegalStateException("Multiple javaagents specified and code source unavailable, not installing tracing agent");
        }
        if (agentArgument == null) {
            throw new IllegalStateException("Could not find javaagent parameter and code source unavailable, not installing tracing agent");
        }
        Matcher matcher = Pattern.compile("-javaagent:([^=]+).*").matcher(agentArgument);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unable to parse javaagent parameter: " + agentArgument);
        }
        File javaagentFile = new File(matcher.group(1));
        if (!javaagentFile.exists() && !javaagentFile.isFile()) {
            throw new IllegalStateException("Unable to find javaagent file: " + javaagentFile);
        }
        ddJavaAgentJarURL = javaagentFile.toURI().toURL();
        AgentBootstrap.checkJarManifestMainClassIsThis(ddJavaAgentJarURL);
        inst.appendToBootstrapClassLoaderSearch(new JarFile(javaagentFile));
        return ddJavaAgentJarURL;
    }

    @SuppressForbidden
    private static List<String> getVMArgumentsThroughReflection() {
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = Class.forName("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException | UnsatisfiedLinkError e) {
            try {
                Class<?> VMClass = Class.forName("com.ibm.oti.vm.VM");
                String[] argArray = (String[])VMClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException e1) {
                System.out.println("WARNING: Unable to get VM args through reflection.  A custom java.util.logging.LogManager may not work correctly");
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }

    private static boolean checkJarManifestMainClassIsThis(URL jarUrl) throws IOException {
        URL manifestUrl = new URL("jar:" + jarUrl + "!/META-INF/MANIFEST.MF");
        String mainClassLine = "Main-Class: " + thisClass.getCanonicalName();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(manifestUrl.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.equals(mainClassLine)) continue;
                boolean bl = true;
                return bl;
            }
        }
        throw new IllegalStateException("dd-java-agent is not installed, because class '" + thisClass.getCanonicalName() + "' is located in '" + jarUrl + "'. Make sure you don't have this .class-file anywhere, besides dd-java-agent.jar");
    }
}

