/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.debugger.CapturedContext;
import datadog.trace.bootstrap.debugger.DebuggerSpan;
import datadog.trace.bootstrap.debugger.MethodLocation;
import datadog.trace.bootstrap.debugger.ProbeImplementation;
import datadog.trace.bootstrap.debugger.ProbeRateLimiter;
import datadog.trace.bootstrap.debugger.util.TimeoutChecker;
import java.util.List;

public class DebuggerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerContext.class);
    private static volatile ProbeResolver probeResolver;
    private static volatile ClassFilter classFilter;
    private static volatile MetricForwarder metricForwarder;
    private static volatile Tracer tracer;
    private static volatile ValueSerializer valueSerializer;

    public static void init(ProbeResolver probeResolver, MetricForwarder metricForwarder) {
        DebuggerContext.probeResolver = probeResolver;
        DebuggerContext.metricForwarder = metricForwarder;
    }

    public static void initTracer(Tracer tracer) {
        DebuggerContext.tracer = tracer;
    }

    public static void initClassFilter(ClassFilter classFilter) {
        DebuggerContext.classFilter = classFilter;
    }

    public static void initValueSerializer(ValueSerializer valueSerializer) {
        DebuggerContext.valueSerializer = valueSerializer;
    }

    public static ProbeImplementation resolveProbe(String id, Class<?> callingClass) {
        ProbeResolver resolver = probeResolver;
        if (resolver == null) {
            return null;
        }
        return resolver.resolve(id, callingClass);
    }

    public static boolean isDenied(String fullyQualifiedClassName) {
        ClassFilter filter = classFilter;
        if (filter == null) {
            LOGGER.warn("no class filter => all classes are denied");
            return true;
        }
        return filter.isDenied(fullyQualifiedClassName);
    }

    public static void count(String name, long delta, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            forwarder.count(name, delta, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in count method: ", ex);
        }
    }

    public static void gauge(String name, long value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            forwarder.gauge(name, value, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in gauge: ", ex);
        }
    }

    public static void histogram(String name, long value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            forwarder.histogram(name, value, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in histogram: ", ex);
        }
    }

    public static String serializeValue(CapturedContext.CapturedValue value) {
        ValueSerializer serializer = valueSerializer;
        if (serializer == null) {
            LOGGER.warn("Cannot serialize value, no serializer set");
            return null;
        }
        return serializer.serializeValue(value);
    }

    public static DebuggerSpan createSpan(String operationName, String[] tags) {
        try {
            Tracer localTracer = tracer;
            if (localTracer == null) {
                return DebuggerSpan.NOOP_SPAN;
            }
            return localTracer.createSpan(operationName, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in createSpan: ", ex);
            return DebuggerSpan.NOOP_SPAN;
        }
    }

    public static boolean isReadyToCapture(String ... probeIds) {
        try {
            if (probeIds == null || probeIds.length == 0) {
                return false;
            }
            boolean result = false;
            for (String probeId : probeIds) {
                result |= ProbeRateLimiter.tryProbe(probeId);
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.debug("Error in isReadyToCapture: ", ex);
            return false;
        }
    }

    public static void evalContext(CapturedContext context, Class<?> callingClass, long startTimestamp, MethodLocation methodLocation, String ... probeIds) {
        try {
            boolean needFreeze = false;
            for (String probeId : probeIds) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeId, callingClass);
                if (probeImplementation == null) continue;
                CapturedContext.Status status = context.evaluate(probeId, probeImplementation, callingClass.getTypeName(), startTimestamp, methodLocation);
                needFreeze |= status.shouldFreezeContext();
            }
            if (needFreeze) {
                context.freeze(new TimeoutChecker(TimeoutChecker.DEFAULT_TIME_OUT));
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContext: ", ex);
        }
    }

    public static void evalContextAndCommit(CapturedContext context, Class<?> callingClass, int line, String ... probeIds) {
        try {
            for (String probeId : probeIds) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeId, callingClass);
                if (probeImplementation == null) continue;
                context.evaluate(probeId, probeImplementation, callingClass.getTypeName(), -1L, MethodLocation.DEFAULT);
                probeImplementation.commit(context, line);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContextAndCommit: ", ex);
        }
    }

    public static void commit(CapturedContext entryContext, CapturedContext exitContext, List<CapturedContext.CapturedThrowable> caughtExceptions, String ... probeIds) {
        try {
            if (entryContext == CapturedContext.EMPTY_CONTEXT && exitContext == CapturedContext.EMPTY_CONTEXT) {
                return;
            }
            for (String probeId : probeIds) {
                ProbeImplementation probeImplementation;
                CapturedContext.Status entryStatus = entryContext.getStatus(probeId);
                CapturedContext.Status exitStatus = exitContext.getStatus(probeId);
                if (entryStatus.probeImplementation != ProbeImplementation.UNKNOWN && (entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.ENTRY || entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.DEFAULT)) {
                    probeImplementation = entryStatus.probeImplementation;
                } else if (exitStatus.probeImplementation.getEvaluateAt() == MethodLocation.EXIT) {
                    probeImplementation = exitStatus.probeImplementation;
                } else {
                    throw new IllegalStateException("no probe details");
                }
                probeImplementation.commit(entryContext, exitContext, caughtExceptions);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in commit: ", ex);
        }
    }

    public static interface ValueSerializer {
        public String serializeValue(CapturedContext.CapturedValue var1);
    }

    public static interface Tracer {
        public DebuggerSpan createSpan(String var1, String[] var2);
    }

    public static interface MetricForwarder {
        public void count(String var1, long var2, String[] var4);

        public void gauge(String var1, long var2, String[] var4);

        public void histogram(String var1, long var2, String[] var4);
    }

    public static interface ClassFilter {
        public boolean isDenied(String var1);
    }

    public static interface ProbeResolver {
        public ProbeImplementation resolve(String var1, Class<?> var2);
    }

    public static enum SkipCause {
        RATE,
        CONDITION;

    }
}

