/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.api.sampling.AdaptiveSampler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ProbeRateLimiter {
    private static final Duration ONE_SECOND_WINDOW = Duration.of(1L, ChronoUnit.SECONDS);
    private static final Duration TEN_SECONDS_WINDOW = Duration.of(10L, ChronoUnit.SECONDS);
    private static final double DEFAULT_RATE = 1.0;
    private static final double DEFAULT_GLOBAL_RATE = 100.0;
    private static final ConcurrentMap<String, AdaptiveSampler> PROBE_SAMPLERS = new ConcurrentHashMap<String, AdaptiveSampler>();
    private static AdaptiveSampler GLOBAL_SAMPLER = ProbeRateLimiter.createSampler(100.0);

    public static boolean tryProbe(String probeId) {
        boolean result = PROBE_SAMPLERS.computeIfAbsent(probeId, k -> ProbeRateLimiter.createSampler(1.0)).sample();
        return result &= GLOBAL_SAMPLER.sample();
    }

    public static void setRate(String probeId, double rate) {
        PROBE_SAMPLERS.put(probeId, ProbeRateLimiter.createSampler(rate));
    }

    public static void setGlobalRate(double rate) {
        GLOBAL_SAMPLER = ProbeRateLimiter.createSampler(rate);
    }

    public static void resetRate(String probeId) {
        PROBE_SAMPLERS.remove(probeId);
    }

    public static void resetGlobalRate() {
        ProbeRateLimiter.setGlobalRate(100.0);
    }

    private static AdaptiveSampler createSampler(double rate) {
        if (rate < 1.0) {
            int intRate = (int)Math.round(rate * 10.0);
            return new AdaptiveSampler(TEN_SECONDS_WINDOW, intRate, 180, 16);
        }
        return new AdaptiveSampler(ONE_SECOND_WINDOW, (int)Math.round(rate), 180, 16);
    }
}

