/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class URIUtils {
    private static final byte[] REPLACEMENT = new byte[]{-17, -65, -67};
    private static final Logger LOGGER = LoggerFactory.getLogger(URIUtils.class);

    private URIUtils() {
    }

    public static String decode(String encoded) {
        return URIUtils.decode(encoded, false);
    }

    public static String decode(String encoded, boolean plusToSpace) {
        if (encoded == null) {
            return null;
        }
        int len = encoded.length();
        if (len == 0) {
            return encoded;
        }
        if (!(encoded.indexOf(37) >= 0 || plusToSpace && encoded.indexOf(43) >= 0)) {
            return encoded;
        }
        ByteBuffer bb = ByteBuffer.allocate(len + 2);
        for (int i = 0; i < len; ++i) {
            int c = encoded.charAt(i);
            if (c == 37) {
                if (i + 2 < len) {
                    int l;
                    int h = Character.digit(encoded.charAt(i + 1), 16);
                    if ((h | (l = Character.digit(encoded.charAt(i + 2), 16))) < 0) {
                        bb.put(REPLACEMENT[0]);
                        bb.put(REPLACEMENT[1]);
                        bb.put(REPLACEMENT[2]);
                    } else {
                        bb.put((byte)((h << 4) + l));
                    }
                    i += 2;
                    continue;
                }
                bb.put(REPLACEMENT[0]);
                bb.put(REPLACEMENT[1]);
                bb.put(REPLACEMENT[2]);
                i = len;
                continue;
            }
            if (plusToSpace && c == 43) {
                c = 32;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return new String(bb.array(), 0, bb.limit(), StandardCharsets.UTF_8);
    }

    public static String buildURL(String scheme, String host, int port, String path) {
        int length = 0;
        length += null == scheme ? 0 : scheme.length() + 3;
        if (null != host) {
            length += host.length();
            if (port > 0 && port != 80 && port != 443) {
                length += 6;
            }
        }
        if (null == path || path.isEmpty()) {
            ++length;
        } else {
            if (path.charAt(0) != '/') {
                ++length;
            }
            length += path.length();
        }
        StringBuilder urlNoParams = new StringBuilder(length);
        if (scheme != null) {
            urlNoParams.append(scheme);
            urlNoParams.append("://");
        }
        if (host != null) {
            urlNoParams.append(host);
            if (!(port <= 0 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                urlNoParams.append(':');
                urlNoParams.append(port);
            }
        }
        if (null == path || path.isEmpty()) {
            urlNoParams.append('/');
        } else {
            if (path.charAt(0) != '/' && urlNoParams.length() > 0) {
                urlNoParams.append('/');
            }
            urlNoParams.append(path);
        }
        return urlNoParams.toString();
    }

    public static URI safeParse(String unparsed) {
        if (unparsed == null) {
            return null;
        }
        try {
            return URI.create(unparsed);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.debug("Unable to parse request uri {}", (Object)unparsed, (Object)exception);
            return null;
        }
    }
}

