/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jdbc;

import datadog.trace.api.Pair;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.bootstrap.ExceptionLogger;
import datadog.trace.bootstrap.instrumentation.jdbc.DBInfo;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JDBCConnectionUrlParser {
    GENERIC_URL_LIKE(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            try {
                String path;
                URI uri = new URI(jdbcUrl);
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(uri.getQuery(), '&'));
                String user = uri.getUserInfo();
                if (user != null) {
                    builder.user(user);
                }
                if ((path = uri.getPath()).startsWith("/")) {
                    path = path.substring(1);
                }
                if (!path.isEmpty()) {
                    builder.db(path);
                }
                if (uri.getHost() != null) {
                    builder.host(uri.getHost());
                }
                if (uri.getPort() > 0) {
                    builder.port(uri.getPort());
                }
                return builder.type(uri.getScheme());
            }
            catch (Exception e) {
                return builder;
            }
        }
    }
    ,
    MODIFIED_URL_LIKE(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int portLoc;
            int instanceLoc;
            String urlServerName;
            String urlPart2;
            String urlPart1;
            String serverName = "";
            Integer port = null;
            String instanceName = null;
            int hostIndex = jdbcUrl.indexOf("://");
            if (hostIndex <= 0) {
                return builder;
            }
            String type = jdbcUrl.substring(0, hostIndex);
            if (type.equals("db2") || type.equals("as400")) {
                if (jdbcUrl.contains("=")) {
                    int paramLoc = jdbcUrl.lastIndexOf(58);
                    urlPart1 = jdbcUrl.substring(0, paramLoc);
                    urlPart2 = jdbcUrl.substring(paramLoc + 1);
                } else {
                    urlPart1 = jdbcUrl;
                    urlPart2 = null;
                }
            } else {
                int paramLoc = jdbcUrl.indexOf(59);
                urlPart1 = paramLoc >= 0 ? jdbcUrl.substring(0, paramLoc) : jdbcUrl;
                String string = urlPart2 = paramLoc >= 0 ? jdbcUrl.substring(paramLoc + 1) : null;
            }
            if (urlPart2 != null) {
                Map props = JDBCConnectionUrlParser.splitQuery(urlPart2, ';');
                JDBCConnectionUrlParser.populateStandardProperties(builder, props);
                if (props.containsKey("servername")) {
                    serverName = (String)props.get("servername");
                }
            }
            if (!(urlServerName = urlPart1.substring(hostIndex + 3)).isEmpty()) {
                serverName = urlServerName;
            }
            if ((instanceLoc = serverName.indexOf(47)) > 1) {
                instanceName = serverName.substring(instanceLoc + 1);
                serverName = serverName.substring(0, instanceLoc);
            }
            if ((portLoc = serverName.indexOf(58)) > 1) {
                port = Integer.parseInt(serverName.substring(portLoc + 1));
                serverName = serverName.substring(0, portLoc);
            }
            if ((instanceLoc = serverName.indexOf(92)) > 1) {
                instanceName = serverName.substring(instanceLoc + 1);
                serverName = serverName.substring(0, instanceLoc);
            }
            if (instanceName != null) {
                builder.instance(instanceName);
            }
            if (!serverName.isEmpty()) {
                builder.host(serverName);
            }
            if (port != null) {
                builder.port(port);
            }
            return builder.type(type);
        }
    }
    ,
    POSTGRES(new String[]{"postgresql"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 5432;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(5432);
            }
            return GENERIC_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    MYSQL(new String[]{"mysql", "mariadb"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 3306;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int hostEndLoc;
            int typeEndLoc;
            int protoLoc;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(3306);
            }
            if ((protoLoc = jdbcUrl.indexOf("://")) > (typeEndLoc = dbInfo.getType().length()) && !jdbcUrl.substring(typeEndLoc + 1, protoLoc).equals("aws")) {
                return MARIA_SUBPROTO.doParse(jdbcUrl.substring(protoLoc + 3), builder).subtype(jdbcUrl.substring(typeEndLoc + 1, protoLoc));
            }
            if (protoLoc > 0) {
                return GENERIC_URL_LIKE.doParse(dbInfo.getType() + jdbcUrl.substring(protoLoc), builder);
            }
            int portLoc = jdbcUrl.indexOf(58, typeEndLoc + 1);
            int dbLoc = jdbcUrl.indexOf(47, typeEndLoc);
            int paramLoc = jdbcUrl.indexOf(63, dbLoc);
            if (paramLoc > 0) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(jdbcUrl.substring(paramLoc + 1), '&'));
                builder.db(jdbcUrl.substring(dbLoc + 1, paramLoc));
            } else {
                builder.db(jdbcUrl.substring(dbLoc + 1));
            }
            if (portLoc > 0) {
                hostEndLoc = portLoc;
                try {
                    builder.port(Integer.parseInt(jdbcUrl.substring(portLoc + 1, dbLoc)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                hostEndLoc = dbLoc;
            }
            builder.host(jdbcUrl.substring(typeEndLoc + 1, hostEndLoc));
            return builder;
        }
    }
    ,
    MARIA_SUBPROTO(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int hostEndLoc;
            int clusterSepLoc = jdbcUrl.indexOf(44);
            int ipv6End = jdbcUrl.startsWith("[") ? jdbcUrl.indexOf(93) : -1;
            int portLoc = jdbcUrl.indexOf(58, Math.max(0, ipv6End));
            int dbLoc = jdbcUrl.indexOf(47, Math.max(portLoc = clusterSepLoc < portLoc ? -1 : portLoc, clusterSepLoc));
            int paramLoc = jdbcUrl.indexOf(63, dbLoc);
            if (paramLoc > 0) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(jdbcUrl.substring(paramLoc + 1), '&'));
                builder.db(jdbcUrl.substring(dbLoc + 1, paramLoc));
            } else {
                builder.db(jdbcUrl.substring(dbLoc + 1));
            }
            if (jdbcUrl.startsWith("address=")) {
                return MARIA_ADDRESS.doParse(jdbcUrl, builder);
            }
            if (portLoc > 0) {
                hostEndLoc = portLoc;
                int portEndLoc = clusterSepLoc > 0 ? clusterSepLoc : dbLoc;
                try {
                    builder.port(Integer.parseInt(jdbcUrl.substring(portLoc + 1, portEndLoc)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                int n = hostEndLoc = clusterSepLoc > 0 ? clusterSepLoc : dbLoc;
            }
            if (ipv6End > 0) {
                builder.host(jdbcUrl.substring(1, ipv6End));
            } else {
                builder.host(jdbcUrl.substring(0, hostEndLoc));
            }
            return builder;
        }
    }
    ,
    MARIA_ADDRESS(new String[0]){
        private final Pattern HOST_REGEX = Pattern.compile("\\(\\s*host\\s*=\\s*([^ )]+)\\s*\\)");
        private final Pattern PORT_REGEX = Pattern.compile("\\(\\s*port\\s*=\\s*([\\d]+)\\s*\\)");
        private final Pattern USER_REGEX = Pattern.compile("\\(\\s*user\\s*=\\s*([^ )]+)\\s*\\)");

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            Matcher userMatcher;
            Matcher portMatcher;
            Matcher hostMatcher;
            int addressEnd = jdbcUrl.indexOf(",address=");
            if (addressEnd > 0) {
                jdbcUrl = jdbcUrl.substring(0, addressEnd);
            }
            if ((hostMatcher = this.HOST_REGEX.matcher(jdbcUrl)).find()) {
                builder.host(hostMatcher.group(1));
            }
            if ((portMatcher = this.PORT_REGEX.matcher(jdbcUrl)).find()) {
                builder.port(Integer.parseInt(portMatcher.group(1)));
            }
            if ((userMatcher = this.USER_REGEX.matcher(jdbcUrl)).find()) {
                builder.user(userMatcher.group(1));
            }
            return builder;
        }
    }
    ,
    SAP(new String[]{"sap"}){
        private static final String DEFAULT_HOST = "localhost";

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            return GENERIC_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    MSSQLSERVER(new String[]{"microsoft", "sqlserver"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_PORT = 1433;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            if (jdbcUrl.startsWith("microsoft:")) {
                jdbcUrl = jdbcUrl.substring("microsoft:".length());
            }
            if (!jdbcUrl.startsWith("sqlserver://")) {
                return builder;
            }
            builder.type("sqlserver");
            DBInfo dbInfo = builder.build();
            if (dbInfo.getHost() == null) {
                builder.host(DEFAULT_HOST);
            }
            if (dbInfo.getPort() == null) {
                builder.port(1433);
            }
            return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    DB2(new String[]{"db2", "as400"}){
        private static final int DEFAULT_PORT = 50000;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            DBInfo dbInfo = builder.build();
            if (dbInfo.getPort() == null) {
                builder.port(50000);
            }
            return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder);
        }
    }
    ,
    ORACLE(new String[]{"oracle"}){
        private static final int DEFAULT_PORT = 1521;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int typeEndIndex = jdbcUrl.indexOf(58, "oracle:".length());
            String subtype = jdbcUrl.substring("oracle:".length(), typeEndIndex);
            jdbcUrl = jdbcUrl.substring(typeEndIndex + 1);
            builder.subtype(subtype);
            DBInfo dbInfo = builder.build();
            if (dbInfo.getPort() == null) {
                builder.port(1521);
            }
            if (jdbcUrl.contains("@")) {
                return ORACLE_AT.doParse(jdbcUrl, builder);
            }
            return ORACLE_CONNECT_INFO.doParse(jdbcUrl, builder);
        }
    }
    ,
    ORACLE_CONNECT_INFO(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String instance;
            Integer port;
            String host;
            int hostEnd = jdbcUrl.indexOf(58);
            int instanceLoc = jdbcUrl.indexOf(47);
            if (hostEnd > 0) {
                host = jdbcUrl.substring(0, hostEnd);
                int afterHostEnd = jdbcUrl.indexOf(58, hostEnd + 1);
                if (afterHostEnd > 0) {
                    port = Integer.parseInt(jdbcUrl.substring(hostEnd + 1, afterHostEnd));
                    instance = jdbcUrl.substring(afterHostEnd + 1);
                } else if (instanceLoc > 0) {
                    instance = jdbcUrl.substring(instanceLoc + 1);
                    port = Integer.parseInt(jdbcUrl.substring(hostEnd + 1, instanceLoc));
                } else {
                    String portOrInstance = jdbcUrl.substring(hostEnd + 1);
                    Integer parsedPort = null;
                    try {
                        parsedPort = Integer.parseInt(portOrInstance);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (parsedPort == null) {
                        port = null;
                        instance = portOrInstance;
                    } else {
                        port = parsedPort;
                        instance = null;
                    }
                }
            } else if (instanceLoc > 0) {
                host = jdbcUrl.substring(0, instanceLoc);
                port = null;
                instance = jdbcUrl.substring(instanceLoc + 1);
            } else {
                if (jdbcUrl.isEmpty()) {
                    return builder;
                }
                host = null;
                port = null;
                instance = jdbcUrl;
            }
            if (host != null) {
                builder.host(host);
            }
            if (port != null) {
                builder.port(port);
            }
            return builder.instance(instance);
        }
    }
    ,
    ORACLE_AT(new String[0]){

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            if (jdbcUrl.contains("@(description")) {
                return ORACLE_AT_DESCRIPTION.doParse(jdbcUrl, builder);
            }
            int atIndex = jdbcUrl.indexOf(64);
            String urlPart1 = jdbcUrl.substring(0, atIndex);
            String connectInfo = jdbcUrl.substring(atIndex + 1);
            int userInfoLoc = urlPart1.indexOf(47);
            String user = userInfoLoc > 0 ? urlPart1.substring(0, userInfoLoc) : null;
            int hostStart = connectInfo.startsWith("//") ? "//".length() : (connectInfo.startsWith("ldap://") ? "ldap://".length() : 0);
            if (user != null) {
                builder.user(user);
            }
            return ORACLE_CONNECT_INFO.doParse(connectInfo.substring(hostStart), builder);
        }
    }
    ,
    ORACLE_AT_DESCRIPTION(new String[0]){
        private final Pattern HOST_REGEX = Pattern.compile("\\(\\s*host\\s*=\\s*([^ )]+)\\s*\\)");
        private final Pattern PORT_REGEX = Pattern.compile("\\(\\s*port\\s*=\\s*([\\d]+)\\s*\\)");
        private final Pattern INSTANCE_REGEX = Pattern.compile("\\(\\s*service_name\\s*=\\s*([^ )]+)\\s*\\)");

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            Matcher instanceMatcher;
            Matcher portMatcher;
            Matcher hostMatcher;
            int atIndex = jdbcUrl.indexOf(64);
            String urlPart1 = jdbcUrl.substring(0, atIndex);
            String urlPart2 = jdbcUrl.substring(atIndex + 1);
            int userInfoLoc = urlPart1.indexOf(47);
            if (userInfoLoc > 0) {
                builder.user(urlPart1.substring(0, userInfoLoc));
            }
            if ((hostMatcher = this.HOST_REGEX.matcher(urlPart2)).find()) {
                builder.host(hostMatcher.group(1));
            }
            if ((portMatcher = this.PORT_REGEX.matcher(urlPart2)).find()) {
                builder.port(Integer.parseInt(portMatcher.group(1)));
            }
            if ((instanceMatcher = this.INSTANCE_REGEX.matcher(urlPart2)).find()) {
                builder.instance(instanceMatcher.group(1));
            }
            return builder;
        }
    }
    ,
    H2(new String[]{"h2"}){
        private static final int DEFAULT_PORT = 8082;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String instance;
            String h2Url = jdbcUrl.substring("h2:".length());
            if (h2Url.startsWith("mem:")) {
                builder.subtype("mem");
                int propLoc = h2Url.indexOf(59);
                instance = propLoc >= 0 ? h2Url.substring("mem:".length(), propLoc) : h2Url.substring("mem:".length());
            } else if (h2Url.startsWith("file:")) {
                builder.subtype("file");
                int propLoc = h2Url.indexOf(59);
                instance = propLoc >= 0 ? h2Url.substring("file:".length(), propLoc) : h2Url.substring("file:".length());
            } else if (h2Url.startsWith("zip:")) {
                builder.subtype("zip");
                int propLoc = h2Url.indexOf(59);
                instance = propLoc >= 0 ? h2Url.substring("zip:".length(), propLoc) : h2Url.substring("zip:".length());
            } else {
                if (h2Url.startsWith("tcp:")) {
                    DBInfo dbInfo = builder.build();
                    if (dbInfo.getPort() == null) {
                        builder.port(8082);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("h2").subtype("tcp");
                }
                if (h2Url.startsWith("ssl:")) {
                    DBInfo dbInfo = builder.build();
                    if (dbInfo.getPort() == null) {
                        builder.port(8082);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("h2").subtype("ssl");
                }
                builder.subtype("file");
                int propLoc = h2Url.indexOf(59);
                instance = propLoc >= 0 ? h2Url.substring(0, propLoc) : h2Url;
            }
            if (!instance.isEmpty()) {
                builder.instance(instance);
            }
            return builder;
        }
    }
    ,
    HSQL(new String[]{"hsqldb"}){
        private static final String DEFAULT_USER = "SA";
        private static final int DEFAULT_PORT = 9001;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String hsqlUrl;
            String instance = null;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getUser() == null) {
                builder.user(DEFAULT_USER);
            }
            if ((hsqlUrl = jdbcUrl.substring("hsqldb:".length())).startsWith("mem:")) {
                builder.subtype("mem");
                instance = hsqlUrl.substring("mem:".length());
            } else if (hsqlUrl.startsWith("file:")) {
                builder.subtype("file");
                instance = hsqlUrl.substring("file:".length());
            } else if (hsqlUrl.startsWith("res:")) {
                builder.subtype("res");
                instance = hsqlUrl.substring("res:".length());
            } else {
                if (hsqlUrl.startsWith("hsql:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(9001);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("hsqldb").subtype("hsql");
                }
                if (hsqlUrl.startsWith("hsqls:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(9001);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("hsqldb").subtype("hsqls");
                }
                if (hsqlUrl.startsWith("http:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(80);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("hsqldb").subtype("http");
                }
                if (hsqlUrl.startsWith("https:")) {
                    if (dbInfo.getPort() == null) {
                        builder.port(443);
                    }
                    return MODIFIED_URL_LIKE.doParse(jdbcUrl, builder).type("hsqldb").subtype("https");
                }
                builder.subtype("mem");
                instance = hsqlUrl;
            }
            return builder.instance(instance);
        }
    }
    ,
    DERBY(new String[]{"derby"}){
        private static final String DEFAULT_USER = "APP";
        private static final int DEFAULT_PORT = 1527;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            String urlPart2;
            String derbyUrl;
            int delimIndex;
            String instance = null;
            String host = null;
            DBInfo dbInfo = builder.build();
            if (dbInfo.getUser() == null) {
                builder.user(DEFAULT_USER);
            }
            String details = (delimIndex = (derbyUrl = jdbcUrl.substring("derby:".length())).indexOf(59)) >= 0 ? derbyUrl.substring(0, delimIndex) : derbyUrl;
            String string = urlPart2 = delimIndex >= 0 ? derbyUrl.substring(delimIndex + 1) : null;
            if (urlPart2 != null) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(urlPart2, ';'));
            }
            if (details.startsWith("memory:")) {
                builder.subtype("memory");
                String urlInstance = details.substring("memory:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("directory:")) {
                builder.subtype("directory");
                String urlInstance = details.substring("directory:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("classpath:")) {
                builder.subtype("classpath");
                String urlInstance = details.substring("classpath:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("jar:")) {
                builder.subtype("jar");
                String urlInstance = details.substring("jar:".length());
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            } else if (details.startsWith("//")) {
                int portLoc;
                String url;
                int instanceLoc;
                builder.subtype("network");
                if (dbInfo.getPort() == null) {
                    builder.port(1527);
                }
                if ((instanceLoc = (url = details.substring("//".length())).indexOf(47)) >= 0) {
                    instance = url.substring(instanceLoc + 1);
                    int protoLoc = instance.indexOf(58);
                    if (protoLoc >= 0) {
                        instance = instance.substring(protoLoc + 1);
                    }
                    url = url.substring(0, instanceLoc);
                }
                if ((portLoc = url.indexOf(58)) > 0) {
                    host = url.substring(0, portLoc);
                    builder.port(Integer.parseInt(url.substring(portLoc + 1)));
                } else {
                    host = url;
                }
            } else {
                builder.subtype("directory");
                String urlInstance = details;
                if (!urlInstance.isEmpty()) {
                    instance = urlInstance;
                }
            }
            if (host != null) {
                builder.host(host);
            }
            return builder.instance(instance);
        }
    }
    ,
    JTDS(new String[]{"jtds"}){
        private static final String DEFAULT_HOST = "localhost";
        private static final int DEFAULT_SQL_SERVER_PORT = 1433;
        private static final int DEFAULT_SYBASE_PORT = 7100;

        @Override
        DBInfo.Builder doParse(String jdbcUrl, DBInfo.Builder builder) {
            int hostEndLoc;
            DBInfo dbInfo = builder.build();
            int protoLoc = jdbcUrl.indexOf("://");
            int typeEndLoc = dbInfo.getType().length();
            String subtype = jdbcUrl.substring(typeEndLoc + 1, protoLoc);
            builder.subtype(subtype);
            if ("sqlserver".equals(subtype)) {
                if (dbInfo.getPort() == null) {
                    builder.port(1433);
                }
            } else if ("sybase".equals(subtype) && dbInfo.getPort() == null) {
                builder.port(7100);
            }
            String details = jdbcUrl.substring(protoLoc + "://".length());
            int portLoc = details.indexOf(58, typeEndLoc + 1);
            int dbLoc = details.indexOf(47, typeEndLoc);
            int paramLoc = details.indexOf(59, dbLoc);
            if (paramLoc > 0) {
                JDBCConnectionUrlParser.populateStandardProperties(builder, JDBCConnectionUrlParser.splitQuery(details.substring(paramLoc + 1), ';'));
                if (dbLoc > 0) {
                    builder.db(details.substring(dbLoc + 1, paramLoc));
                }
            } else if (dbLoc > 0) {
                builder.db(details.substring(dbLoc + 1));
            }
            if (portLoc > 0) {
                hostEndLoc = portLoc;
                try {
                    builder.port(Integer.parseInt(details.substring(portLoc + 1, dbLoc)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                hostEndLoc = dbLoc > 0 ? dbLoc : (paramLoc > 0 ? paramLoc : details.length());
            }
            builder.host(details.substring(0, hostEndLoc));
            return builder;
        }
    };

    private static final Map<String, JDBCConnectionUrlParser> typeParsers;
    private static final DDCache<Pair<String, Properties>, DBInfo> CACHED_DB_INFO;
    private static final Function<Pair<String, Properties>, DBInfo> PARSE;
    private final String[] typeKeys;

    private JDBCConnectionUrlParser(String ... typeKeys) {
        this.typeKeys = typeKeys;
    }

    abstract DBInfo.Builder doParse(String var1, DBInfo.Builder var2);

    public static DBInfo extractDBInfo(String connectionUrl, Properties props) {
        return CACHED_DB_INFO.computeIfAbsent(Pair.of(connectionUrl, props), PARSE);
    }

    public static DBInfo parse(String connectionUrl, Properties props) {
        if (connectionUrl == null) {
            return DBInfo.DEFAULT;
        }
        if (!(connectionUrl = connectionUrl.toLowerCase()).startsWith("jdbc:")) {
            return DBInfo.DEFAULT;
        }
        String jdbcUrl = connectionUrl.substring("jdbc:".length());
        int typeLoc = jdbcUrl.indexOf(58);
        if (typeLoc < 1) {
            return DBInfo.DEFAULT;
        }
        String baseType = jdbcUrl.substring(0, typeLoc);
        DBInfo.Builder parsedProps = DBInfo.DEFAULT.toBuilder().type(baseType);
        JDBCConnectionUrlParser.populateStandardProperties(parsedProps, props);
        try {
            if (typeParsers.containsKey(baseType)) {
                return typeParsers.get(baseType).doParse(jdbcUrl, parsedProps).build();
            }
            return GENERIC_URL_LIKE.doParse(connectionUrl, parsedProps).build();
        }
        catch (Exception e) {
            ExceptionLogger.LOGGER.debug("Error parsing URL", e);
            return parsedProps.build();
        }
    }

    @SuppressForbidden
    private static Map<String, String> splitQuery(String query, char separator) {
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        int start = 0;
        int i = query.indexOf(separator);
        while (start != -1) {
            try {
                String key;
                String pair = i >= 0 ? query.substring(start, i) : query.substring(start);
                int idx = pair.indexOf(61);
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                if (!query_pairs.containsKey(key)) {
                    String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                    query_pairs.put(key, value);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            start = i == -1 ? i : i + 1;
            i = query.indexOf(separator, i + 1);
        }
        return query_pairs;
    }

    private static void populateStandardProperties(DBInfo.Builder builder, Map<?, ?> props) {
        if (props != null && !props.isEmpty()) {
            String portNumber;
            if (props.containsKey("user")) {
                builder.user((String)props.get("user"));
            }
            if (props.containsKey("databasename")) {
                builder.db((String)props.get("databasename"));
            }
            if (props.containsKey("databaseName")) {
                builder.db((String)props.get("databaseName"));
            }
            if (props.containsKey("servername")) {
                builder.host((String)props.get("servername"));
            }
            if (props.containsKey("serverName")) {
                builder.host((String)props.get("serverName"));
            }
            if (props.containsKey("portnumber")) {
                portNumber = (String)props.get("portnumber");
                try {
                    builder.port(Integer.parseInt(portNumber));
                }
                catch (NumberFormatException e) {
                    ExceptionLogger.LOGGER.debug("Error parsing portnumber property: " + portNumber, e);
                }
            }
            if (props.containsKey("portNumber")) {
                portNumber = (String)props.get("portNumber");
                try {
                    builder.port(Integer.parseInt(portNumber));
                }
                catch (NumberFormatException e) {
                    ExceptionLogger.LOGGER.debug("Error parsing portNumber property: " + portNumber, e);
                }
            }
        }
    }

    static {
        typeParsers = new HashMap<String, JDBCConnectionUrlParser>();
        for (JDBCConnectionUrlParser parser : JDBCConnectionUrlParser.values()) {
            for (String key : parser.typeKeys) {
                typeParsers.put(key, parser);
            }
        }
        CACHED_DB_INFO = DDCaches.newFixedSizeCache(32);
        PARSE = input -> JDBCConnectionUrlParser.parse((String)input.getLeft(), (Properties)input.getRight());
    }
}

