/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast.telemetry;

import datadog.trace.api.iast.SourceTypes;
import datadog.trace.api.iast.VulnerabilityTypes;
import datadog.trace.api.iast.telemetry.Verbosity;
import java.util.function.Function;
import javax.annotation.Nonnull;

public enum IastMetric {
    INSTRUMENTED_PROPAGATION("instrumented.propagation", true, Scope.GLOBAL, Verbosity.MANDATORY),
    INSTRUMENTED_SOURCE("instrumented.source", true, Scope.GLOBAL, Tag.SOURCE_TYPE, Verbosity.MANDATORY),
    INSTRUMENTED_SINK("instrumented.sink", true, Scope.GLOBAL, Tag.VULNERABILITY_TYPE, Verbosity.MANDATORY),
    EXECUTED_PROPAGATION("executed.propagation", true, Scope.REQUEST, Verbosity.DEBUG),
    EXECUTED_SOURCE("executed.source", true, Scope.REQUEST, Tag.SOURCE_TYPE, Verbosity.INFORMATION),
    EXECUTED_SINK("executed.sink", true, Scope.REQUEST, Tag.VULNERABILITY_TYPE, Verbosity.INFORMATION),
    EXECUTED_TAINTED("executed.tainted", true, Scope.REQUEST, Verbosity.DEBUG),
    REQUEST_TAINTED("request.tainted", true, Scope.REQUEST, Verbosity.INFORMATION),
    TAINTED_FLAT_MODE("tainted.flat.mode", false, Scope.REQUEST, Verbosity.INFORMATION);

    private static final int COUNT;
    private final String name;
    private final boolean common;
    private final Scope scope;
    private final Tag tag;
    private final Verbosity verbosity;
    private int index;

    public static int count() {
        return COUNT;
    }

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity) {
        this(name, common, scope, null, verbosity);
    }

    private IastMetric(String name, boolean common, Scope scope, Tag tag, Verbosity verbosity) {
        this.name = name;
        this.common = common;
        this.scope = scope;
        this.tag = tag;
        this.verbosity = verbosity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCommon() {
        return this.common;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isEnabled(@Nonnull Verbosity verbosity) {
        return verbosity.isEnabled(this.verbosity);
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getIndex(byte tagValue) {
        if (this.tag == null) {
            return this.index;
        }
        if (tagValue < 0) {
            return -1;
        }
        return this.index + tagValue;
    }

    static {
        int count = 0;
        for (IastMetric metric : IastMetric.values()) {
            metric.index = count++;
            if (metric.tag == null) continue;
            count += metric.tag.getValues().length;
        }
        COUNT = count;
    }

    public static final class Scope {
        public static final Scope GLOBAL = new Scope("global");
        public static final Scope REQUEST = new Scope("request");
        private final String name;

        private Scope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Tag {
        private static final byte[] EMPTY = new byte[0];
        public static final Tag VULNERABILITY_TYPE = new Tag("vulnerability_type", VulnerabilityTypes.values(), VulnerabilityTypes::toString){

            @Override
            public boolean isWrapped(byte tagValue) {
                switch (tagValue) {
                    case -128: 
                    case -127: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public byte[] unwrap(byte tagValue) {
                switch (tagValue) {
                    case -128: {
                        return VulnerabilityTypes.RESPONSE_HEADER_TYPES;
                    }
                    case -127: {
                        return VulnerabilityTypes.SPRING_RESPONSE_TYPES;
                    }
                }
                return EMPTY;
            }
        };
        public static final Tag SOURCE_TYPE = new Tag("source_type", SourceTypes.values(), SourceTypes::toString);
        private final String name;
        private final Function<Byte, String> toString;
        private final byte[] values;

        private Tag(String name, byte[] values, Function<Byte, String> toString) {
            this.name = name;
            this.toString = toString;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getValues() {
            return this.values;
        }

        public boolean isWrapped(byte tagValue) {
            return false;
        }

        public byte[] unwrap(byte tagValue) {
            return EMPTY;
        }

        public String toString(byte tagValue) {
            return this.toString.apply(tagValue);
        }
    }
}

