/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.ddlogger;

import datadog.slf4j.ILoggerFactory;
import datadog.slf4j.Logger;
import datadog.slf4j.Marker;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LogLevelSwitcher;
import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.LoggerHelperFactory;
import datadog.trace.logging.LoggingSettingsDescription;
import datadog.trace.logging.ddlogger.DDLogger;
import datadog.trace.logging.simplelogger.SLCompatFactory;

public class DDLoggerFactory
implements ILoggerFactory,
LogLevelSwitcher {
    private volatile LoggerHelperFactory helperFactory = null;
    private volatile LogLevel override = null;

    public DDLoggerFactory() {
    }

    public DDLoggerFactory(LoggerHelperFactory helperFactory) {
        this.helperFactory = helperFactory;
    }

    @Override
    public void switchLevel(LogLevel level) {
        this.override = level;
    }

    @Override
    public void restore() {
        this.override = null;
    }

    @Override
    public Logger getLogger(String name) {
        LoggerHelper helper = this.getHelperFactory().loggerHelperForName(name);
        return new DDLogger(new HelperWrapper(helper), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerHelperFactory getHelperFactory() {
        LoggerHelperFactory factory = this.helperFactory;
        if (factory == null) {
            DDLoggerFactory dDLoggerFactory = this;
            synchronized (dDLoggerFactory) {
                factory = this.helperFactory;
                if (factory == null) {
                    factory = this.helperFactory = new SLCompatFactory();
                    LoggingSettingsDescription.setDescription(factory.getSettingsDescription());
                }
            }
        }
        return factory;
    }

    @Override
    public void reinitialize() {
        this.helperFactory = null;
    }

    final class HelperWrapper
    extends LoggerHelper {
        private final LoggerHelper delegate;

        private HelperWrapper(LoggerHelper delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean enabled(LogLevel level, Marker marker) {
            LogLevel levelOverride = DDLoggerFactory.this.override;
            if (levelOverride != null) {
                return level.isEnabled(levelOverride);
            }
            return this.delegate.enabled(level, marker);
        }

        @Override
        public void log(LogLevel level, Marker marker, String message, Throwable t) {
            this.delegate.log(level, marker, message, t);
        }
    }
}

