/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.simplelogger;

import datadog.slf4j.Marker;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.simplelogger.SLCompatFactory;
import datadog.trace.logging.simplelogger.SLCompatSettings;

class SLCompatHelper
extends LoggerHelper {
    private final String logName;
    private final LogLevel logLevel;
    private final SLCompatSettings settings;

    SLCompatHelper(String name, SLCompatSettings settings) {
        this(settings.logNameForName(name), settings.logLevelForName(name), settings);
    }

    SLCompatHelper(String logName, LogLevel logLevel, SLCompatSettings settings) {
        this.logName = logName;
        this.logLevel = logLevel;
        this.settings = settings;
    }

    @Override
    public boolean enabled(LogLevel level, Marker marker) {
        return level.isEnabled(this.logLevel);
    }

    @Override
    public void log(LogLevel level, Marker marker, String message, Throwable t) {
        long timeMillis = Integer.MIN_VALUE;
        if (this.settings.showDateTime) {
            timeMillis = System.currentTimeMillis();
        }
        this.log(level, marker, SLCompatFactory.START_TIME, timeMillis, message, t);
    }

    void log(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String message, Throwable t) {
        String threadName = null;
        if (this.settings.showThreadName) {
            threadName = Thread.currentThread().getName();
        }
        this.log(level, marker, startTimeMillis, timeMillis, threadName, message, t);
    }

    void log(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String threadName, String message, Throwable t) {
        StringBuilder buf = new StringBuilder(32);
        if (timeMillis >= 0L && this.settings.showDateTime) {
            this.settings.dateTimeFormatter.appendFormattedDate(buf, timeMillis, startTimeMillis);
            buf.append(' ');
        }
        if (this.settings.showThreadName && threadName != null) {
            buf.append('[');
            buf.append(threadName);
            buf.append("] ");
        }
        if (this.settings.levelInBrackets) {
            buf.append('[');
        }
        if (this.settings.warnLevelString != null && level == LogLevel.WARN) {
            buf.append(this.settings.warnLevelString);
        } else if (marker != null) {
            buf.append(marker.getName());
        } else {
            buf.append(level.name());
        }
        if (this.settings.levelInBrackets) {
            buf.append(']');
        }
        buf.append(' ');
        if (this.logName.length() > 0) {
            buf.append(this.logName).append(" - ");
        }
        buf.append(message);
        if (this.settings.embedException) {
            this.embedException(buf, t);
        }
        this.settings.printStream.println(buf.toString());
        if (!this.settings.embedException && t != null) {
            t.printStackTrace(this.settings.printStream);
        }
    }

    private void embedException(StringBuilder buf, Throwable t) {
        if (t != null) {
            buf.append(" [exception:");
            buf.append(t.toString());
            buf.append(".");
            for (StackTraceElement element : t.getStackTrace()) {
                buf.append(" at ");
                buf.append(element.toString());
            }
            buf.append("]");
        }
    }
}

