/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WellKnownClasses {
    private static Set<String> toStringFinalSafeClasses = new HashSet<String>(Arrays.asList("java.lang.Class", "java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Character", "java.lang.Byte", "java.lang.Float", "java.lang.Short", "java.math.BigDecimal", "java.math.BigInteger", "java.time.Duration", "java.time.Instant", "java.time.LocalTime", "java.time.LocalDate", "java.time.LocalDateTime", "java.util.UUID", "java.net.URI"));
    private static Set<String> toStringSafeClasses = new HashSet<String>();
    private static Set<String> stringPrimitives;

    public static boolean isToStringFinalSafe(String type) {
        return toStringFinalSafeClasses.contains(type);
    }

    public static boolean isToStringSafe(String concreteType) {
        return toStringSafeClasses.contains(concreteType);
    }

    public static boolean isSizeSafe(Collection<?> collection) {
        String className = collection.getClass().getTypeName();
        return className.startsWith("java.");
    }

    public static boolean isSizeSafe(Map<?, ?> map) {
        String className = map.getClass().getTypeName();
        return className.startsWith("java.");
    }

    public static boolean isStringPrimitive(String type) {
        return stringPrimitives.contains(type);
    }

    static {
        toStringSafeClasses.addAll(toStringFinalSafeClasses);
        toStringSafeClasses.addAll(Arrays.asList("java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong"));
        stringPrimitives = new HashSet<String>(Arrays.asList("java.lang.Class", "java.lang.String", "java.time.Duration", "java.time.Instant", "java.time.LocalTime", "java.time.LocalDate", "java.time.LocalDateTime", "java.util.UUID"));
    }
}

