/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.api.GenericClassValue;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.java.concurrent.AdviceUtils;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ExcludeFilter;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;
import datadog.trace.bootstrap.instrumentation.java.concurrent.Wrapper;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public final class TPEHelper {
    private static final boolean useWrapping;
    private static final Set<String> excludedClasses;
    private static final ThreadLocal<AgentScope> threadLocalScope;
    private static final ClassValue<Boolean> WRAP;

    public static boolean useWrapping(Runnable task) {
        return useWrapping || task instanceof Wrapper || task != null && WRAP.get(task.getClass()) != false;
    }

    public static void setPropagate(ContextStore<ThreadPoolExecutor, Boolean> contextStore, ThreadPoolExecutor executor) {
        if (executor == null || contextStore == null || contextStore.get(executor) != null) {
            return;
        }
        String executorType = executor.getClass().getName();
        if (excludedClasses.contains(executorType)) {
            contextStore.put(executor, Boolean.FALSE);
        } else {
            contextStore.put(executor, Boolean.TRUE);
        }
    }

    public static boolean shouldPropagate(ContextStore<ThreadPoolExecutor, Boolean> contextStore, ThreadPoolExecutor executor) {
        if (executor == null || contextStore == null) {
            return false;
        }
        return Boolean.TRUE.equals(contextStore.get(executor));
    }

    public static void capture(ContextStore<Runnable, State> contextStore, Runnable task) {
        if (task != null && !ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            AdviceUtils.capture(contextStore, task, true);
        }
    }

    public static AgentScope startScope(ContextStore<Runnable, State> contextStore, Runnable task) {
        if (task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return null;
        }
        return AdviceUtils.startTaskScope(contextStore, task);
    }

    public static void setThreadLocalScope(AgentScope scope, Runnable task) {
        if (scope == null || task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return;
        }
        AgentScope current = threadLocalScope.get();
        if (current != null) {
            current.close();
        }
        threadLocalScope.set(scope);
    }

    public static AgentScope getAndClearThreadLocalScope(Runnable task) {
        if (task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return null;
        }
        AgentScope scope = threadLocalScope.get();
        threadLocalScope.set(null);
        return scope;
    }

    public static void endScope(AgentScope scope, Runnable task) {
        if (task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return;
        }
        AdviceUtils.endTaskScope(scope);
    }

    public static void cancelTask(ContextStore<Runnable, State> contextStore, Runnable task) {
        if (task == null || ExcludeFilter.exclude(ExcludeFilter.ExcludeType.RUNNABLE, task)) {
            return;
        }
        AdviceUtils.cancelTask(contextStore, task);
    }

    static {
        WRAP = GenericClassValue.of(input -> {
            String className = input.getName();
            return className.indexOf(47, className.lastIndexOf(46)) > 0;
        });
        InstrumenterConfig config = InstrumenterConfig.get();
        useWrapping = config.isLegacyInstrumentationEnabled(false, "trace.thread-pool-executors");
        excludedClasses = config.getTraceThreadPoolExecutorsExclude();
        threadLocalScope = useWrapping ? null : new ThreadLocal();
    }
}

