/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jdbc;

import java.util.Objects;

public class DBInfo {
    public static DBInfo DEFAULT = new Builder().type("database").build();
    private final String type;
    private final String subtype;
    private final boolean fullPropagationSupport;
    private final String url;
    private final String user;
    private final String instance;
    private final String db;
    private final String host;
    private final Integer port;

    DBInfo(String type, String subtype, boolean fullPropagationSupport, String url, String user, String instance, String db, String host, Integer port) {
        this.type = type;
        this.subtype = subtype;
        this.fullPropagationSupport = fullPropagationSupport;
        this.url = url;
        this.user = user;
        this.instance = instance;
        this.db = db;
        this.host = host;
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean getFullPropagationSupport() {
        return this.fullPropagationSupport;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDb() {
        return this.db;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Builder toBuilder() {
        return new Builder(this.type, this.subtype, this.fullPropagationSupport, this.url, this.user, this.instance, this.db, this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBInfo dbInfo = (DBInfo)o;
        return Objects.equals(this.type, dbInfo.type) && Objects.equals(this.subtype, dbInfo.subtype) && this.fullPropagationSupport == dbInfo.fullPropagationSupport && Objects.equals(this.url, dbInfo.url) && Objects.equals(this.user, dbInfo.user) && Objects.equals(this.instance, dbInfo.instance) && Objects.equals(this.db, dbInfo.db) && Objects.equals(this.host, dbInfo.host) && Objects.equals(this.port, dbInfo.port);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.fullPropagationSupport, this.url, this.user, this.instance, this.db, this.host, this.port);
    }

    public static class Builder {
        private String type;
        private String subtype;
        private boolean fullPropagationSupport = true;
        private String url;
        private String user;
        private String instance;
        private String db;
        private String host;
        private Integer port;

        Builder() {
        }

        Builder(String type, String subtype, boolean fullPropagationSupport, String url, String user, String instance, String db, String host, Integer port) {
            this.type = type;
            this.subtype = subtype;
            this.fullPropagationSupport = fullPropagationSupport;
            this.url = url;
            this.user = user;
            this.instance = instance;
            this.db = db;
            this.host = host;
            this.port = port;
        }

        public Builder type(String type) {
            this.type = type;
            if (type.equals("oracle") || type.equals("sqlserver")) {
                this.fullPropagationSupport = false;
            }
            return this;
        }

        public Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder fullPropagationSupport(boolean fullPropagationSupport) {
            this.fullPropagationSupport = fullPropagationSupport;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public DBInfo build() {
            return new DBInfo(this.type, this.subtype, this.fullPropagationSupport, this.url, this.user, this.instance, this.db, this.host, this.port);
        }
    }
}

