/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.directallocation;

import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationSource;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationTotalEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;

public class AllocatorHistogram
extends ClassValue<AtomicLong[]> {
    private final List<WeakReference<Class<?>>> refs = new CopyOnWriteArrayList();
    private final EventType eventType = EventType.getEventType(DirectAllocationTotalEvent.class);
    private final Runnable eventHook = this::emit;

    AllocatorHistogram() {
        FlightRecorder.addPeriodicEvent(DirectAllocationTotalEvent.class, this.eventHook);
    }

    void deregister() {
        FlightRecorder.removePeriodicEvent(this.eventHook);
    }

    public boolean record(Class<?> caller, DirectAllocationSource allocationSource, long allocated) {
        if (!this.eventType.isEnabled()) {
            return false;
        }
        long total = ((AtomicLong[])this.get(caller))[allocationSource.ordinal()].getAndAdd(allocated);
        return total == 0L;
    }

    @Override
    protected AtomicLong[] computeValue(Class<?> type) {
        this.refs.add(new WeakReference(type));
        AtomicLong[] values = new AtomicLong[DirectAllocationSource.VALUES.length];
        Arrays.setAll(values, i -> new AtomicLong());
        return values;
    }

    private void emit() {
        for (WeakReference<Class<?>> ref : this.refs) {
            AtomicLong[] counts;
            Class clazz = (Class)ref.get();
            if (clazz == null || (counts = (AtomicLong[])this.get(clazz)) == null) continue;
            String name = clazz.getName();
            for (DirectAllocationSource source : DirectAllocationSource.VALUES) {
                long size = counts[source.ordinal()].getAndSet(0L);
                if (size <= 0L) continue;
                new DirectAllocationTotalEvent(name, source.name(), size).commit();
            }
        }
    }
}

