/*
 * Decompiled with CFR 0.152.
 */
package datadog.compiler.utils;

import datadog.compiler.annotations.MethodLines;
import datadog.compiler.annotations.SourcePath;
import java.lang.reflect.Executable;

public class CompilerUtils {
    public static final int LINE_UNKNOWN = -1;

    public static String getSourcePath(Class<?> clazz) {
        SourcePath sourcePathAnnotation = clazz.getAnnotation(SourcePath.class);
        if (sourcePathAnnotation != null) {
            return sourcePathAnnotation.value();
        }
        if (clazz.isAnonymousClass()) {
            try {
                Class<?> enclosingClass = clazz.getEnclosingClass();
                if (enclosingClass != null) {
                    return CompilerUtils.getSourcePath(enclosingClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getStartLine(Executable executable) {
        MethodLines methodLines = executable.getAnnotation(MethodLines.class);
        return methodLines != null ? methodLines.start() : -1;
    }

    public static int getEndLine(Executable executable) {
        MethodLines methodLines = executable.getAnnotation(MethodLines.class);
        return methodLines != null ? methodLines.end() : -1;
    }
}

