/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast.telemetry;

import datadog.trace.api.iast.SourceTypes;
import datadog.trace.api.iast.VulnerabilityTypes;
import datadog.trace.api.iast.telemetry.Verbosity;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum IastMetric {
    INSTRUMENTED_PROPAGATION("instrumented.propagation", true, Scope.GLOBAL, Verbosity.MANDATORY),
    INSTRUMENTED_SOURCE("instrumented.source", true, Scope.GLOBAL, Tag.SOURCE_TYPE, Verbosity.MANDATORY),
    INSTRUMENTED_SINK("instrumented.sink", true, Scope.GLOBAL, Tag.VULNERABILITY_TYPE, Verbosity.MANDATORY),
    EXECUTED_PROPAGATION("executed.propagation", true, Scope.REQUEST, Verbosity.DEBUG),
    EXECUTED_SOURCE("executed.source", true, Scope.REQUEST, Tag.SOURCE_TYPE, Verbosity.INFORMATION),
    EXECUTED_SINK("executed.sink", true, Scope.REQUEST, Tag.VULNERABILITY_TYPE, Verbosity.INFORMATION),
    EXECUTED_TAINTED("executed.tainted", true, Scope.REQUEST, Verbosity.DEBUG),
    REQUEST_TAINTED("request.tainted", true, Scope.REQUEST, Verbosity.INFORMATION),
    TAINTED_FLAT_MODE("tainted.flat.mode", false, Scope.GLOBAL, Verbosity.INFORMATION);

    private static final int COUNT;
    public static final String TRACE_METRIC_PREFIX = "_dd.iast.telemetry.";
    private final String name;
    private final boolean common;
    private final Scope scope;
    private final Tag tag;
    private final Verbosity verbosity;
    private int index;
    private final String[] spanTags;

    public static int count() {
        return COUNT;
    }

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity) {
        this(name, common, scope, null, verbosity);
    }

    private IastMetric(String name, boolean common, Scope scope, Tag tag, Verbosity verbosity) {
        this.name = name;
        this.common = common;
        this.scope = scope;
        this.tag = tag;
        this.verbosity = verbosity;
        this.spanTags = this.computeSpanTags(name, tag);
    }

    private String[] computeSpanTags(String name, Tag tag) {
        String[] result = new String[tag == null ? 1 : tag.count()];
        if (tag == null) {
            result[0] = TRACE_METRIC_PREFIX + name;
        } else {
            for (int i = 0; i < result.length; ++i) {
                String spanTagValue = tag.values[i].toLowerCase(Locale.ROOT).replace('.', '_');
                result[i] = TRACE_METRIC_PREFIX + name + '.' + spanTagValue;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCommon() {
        return this.common;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isEnabled(@Nonnull Verbosity verbosity) {
        return verbosity.isEnabled(this.verbosity);
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getIndex(byte tagValue) {
        if (this.tag == null) {
            return this.index;
        }
        if (tagValue < 0) {
            return -1;
        }
        return this.index + tagValue;
    }

    public String getTelemetryTag(byte tagValue) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.getTelemetryTag(tagValue);
    }

    public String getSpanTag(byte tagValue) {
        if (this.tag == null) {
            return this.spanTags[0];
        }
        return this.spanTags[tagValue];
    }

    static {
        int count = 0;
        for (IastMetric metric : IastMetric.values()) {
            metric.index = count++;
            if (metric.tag == null) continue;
            count += metric.tag.count();
        }
        COUNT = count;
    }

    public static final class Scope {
        public static final Scope GLOBAL = new Scope("global");
        public static final Scope REQUEST = new Scope("request");
        private final String name;

        private Scope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static abstract class Tag {
        public static final Tag VULNERABILITY_TYPE = new Tag("vulnerability_type", VulnerabilityTypes.STRINGS){

            @Override
            @Nullable
            public byte[] unwrap(byte tagValue) {
                return VulnerabilityTypes.unwrap(tagValue);
            }
        };
        public static final Tag SOURCE_TYPE = new Tag("source_type", SourceTypes.STRINGS){

            @Override
            @Nullable
            public byte[] unwrap(byte tagValue) {
                return SourceTypes.unwrap(tagValue);
            }
        };
        protected final String name;
        protected final String[] values;
        protected final String[] telemetryTags;

        private Tag(String name, String[] values) {
            this.name = name;
            this.values = values;
            this.telemetryTags = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.telemetryTags[i] = name + ":" + values[i];
            }
        }

        public String getName() {
            return this.name;
        }

        public int count() {
            return this.values.length;
        }

        @Nullable
        public abstract byte[] unwrap(byte var1);

        public String getTelemetryTag(byte tagValue) {
            return this.telemetryTags[tagValue];
        }
    }
}

