/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.sampling.AdaptiveSampler;
import datadog.trace.api.sampling.ConstantSampler;
import datadog.trace.api.sampling.Sampler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.DoubleFunction;

public class ProbeRateLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeRateLimiter.class);
    public static final double DEFAULT_SNAPSHOT_RATE = 1.0;
    public static final double DEFAULT_LOG_RATE = 5000.0;
    private static final Duration ONE_SECOND_WINDOW = Duration.of(1L, ChronoUnit.SECONDS);
    private static final Duration TEN_SECONDS_WINDOW = Duration.of(10L, ChronoUnit.SECONDS);
    private static final double DEFAULT_GLOBAL_SNAPSHOT_RATE = 100.0;
    private static final double DEFAULT_GLOBAL_LOG_RATE = 5000.0;
    private static final ConcurrentMap<String, RateLimitInfo> PROBE_SAMPLERS = new ConcurrentHashMap<String, RateLimitInfo>();
    private static Sampler GLOBAL_SNAPSHOT_SAMPLER = ProbeRateLimiter.createSampler(100.0);
    private static Sampler GLOBAL_LOG_SAMPLER = ProbeRateLimiter.createSampler(5000.0);
    private static DoubleFunction<Sampler> samplerSupplier = ProbeRateLimiter::createSampler;

    public static boolean tryProbe(String probeId) {
        Sampler globalSampler;
        RateLimitInfo rateLimitInfo = PROBE_SAMPLERS.computeIfAbsent(probeId, ProbeRateLimiter::getDefaultRateLimitInfo);
        Sampler sampler = globalSampler = rateLimitInfo.isCaptureSnapshot ? GLOBAL_SNAPSHOT_SAMPLER : GLOBAL_LOG_SAMPLER;
        if (globalSampler.sample()) {
            return rateLimitInfo.sampler.sample();
        }
        return false;
    }

    private static RateLimitInfo getDefaultRateLimitInfo(String probeId) {
        LOGGER.debug("Setting sampling with default snapshot rate for probeId={}", (Object)probeId);
        return new RateLimitInfo(samplerSupplier.apply(1.0), true);
    }

    public static void setRate(String probeId, double rate, boolean isCaptureSnapshot) {
        PROBE_SAMPLERS.put(probeId, new RateLimitInfo(samplerSupplier.apply(rate), isCaptureSnapshot));
    }

    public static void setGlobalSnapshotRate(double rate) {
        GLOBAL_SNAPSHOT_SAMPLER = samplerSupplier.apply(rate);
    }

    public static void setGlobalLogRate(double rate) {
        GLOBAL_LOG_SAMPLER = samplerSupplier.apply(rate);
    }

    public static void resetRate(String probeId) {
        PROBE_SAMPLERS.remove(probeId);
    }

    public static void resetGlobalRate() {
        ProbeRateLimiter.setGlobalSnapshotRate(5000.0);
    }

    public static void resetAll() {
        PROBE_SAMPLERS.clear();
        ProbeRateLimiter.resetGlobalRate();
    }

    public static void setSamplerSupplier(DoubleFunction<Sampler> samplerSupplier) {
        ProbeRateLimiter.samplerSupplier = samplerSupplier != null ? samplerSupplier : ProbeRateLimiter::createSampler;
    }

    private static Sampler createSampler(double rate) {
        if (rate < 0.0) {
            return new ConstantSampler(true);
        }
        if (rate < 1.0) {
            int intRate = (int)Math.round(rate * 10.0);
            return new AdaptiveSampler(TEN_SECONDS_WINDOW, intRate, 180, 16, true);
        }
        return new AdaptiveSampler(ONE_SECOND_WINDOW, (int)Math.round(rate), 180, 16, true);
    }

    private static class RateLimitInfo {
        final Sampler sampler;
        final boolean isCaptureSnapshot;

        public RateLimitInfo(Sampler sampler, boolean isCaptureSnapshot) {
            this.sampler = sampler;
            this.isCaptureSnapshot = isCaptureSnapshot;
        }
    }
}

