/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.iast;

import datadog.trace.api.iast.IastContext;
import datadog.trace.api.iast.InstrumentationBridge;
import datadog.trace.api.iast.Taintable;
import datadog.trace.api.iast.propagation.PropagationModule;
import datadog.trace.bootstrap.ContextStore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class NamedContext {
    public abstract void taintValue(@Nullable String var1);

    public abstract void taintName(@Nullable String var1);

    @Nonnull
    public static <E> NamedContext getOrCreate(@Nonnull ContextStore<E, NamedContext> store, @Nonnull E target) {
        Taintable.Source source;
        NamedContext result = store.get(target);
        if (result != null) {
            return result;
        }
        PropagationModule module = InstrumentationBridge.PROPAGATION;
        if (module != null && (source = module.findSource(target)) != null) {
            result = new NamedContextImpl(module, source);
        }
        result = result == null ? NoOp.INSTANCE : result;
        store.put(target, result);
        return result;
    }

    private static class NamedContextImpl
    extends NamedContext {
        @Nonnull
        private final PropagationModule module;
        @Nonnull
        private final Taintable.Source source;
        @Nullable
        private String currentName;
        private boolean fetched;
        @Nullable
        private IastContext context;

        public NamedContextImpl(@Nonnull PropagationModule module, @Nonnull Taintable.Source source) {
            this.module = module;
            this.source = source;
        }

        @Override
        public void taintValue(@Nullable String value) {
            this.module.taint(this.iastCtx(), (Object)value, this.source.getOrigin(), this.currentName, this.source.getValue());
        }

        @Override
        @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
        public void taintName(@Nullable String name) {
            if (this.currentName != name) {
                this.currentName = name;
                this.module.taint(this.iastCtx(), (Object)name, this.source.getOrigin(), name, this.source.getValue());
            }
        }

        private IastContext iastCtx() {
            if (!this.fetched) {
                this.fetched = true;
                this.context = IastContext.Provider.get();
            }
            return this.context;
        }
    }

    private static class NoOp
    extends NamedContext {
        private static final NamedContext INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public void taintValue(@Nullable String value) {
        }

        @Override
        public void taintName(@Nullable String name) {
        }
    }
}

