/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.messaging;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class DatadogAttributeParser {
    private static final Logger log = LoggerFactory.getLogger(DatadogAttributeParser.class);
    private static final Base64.Decoder BASE_64 = Base64.getDecoder();

    public static void forEachProperty(AgentPropagation.KeyClassifier classifier, String json) {
        if (null == json) {
            return;
        }
        try {
            if (DatadogAttributeParser.acceptJsonProperty(classifier, json, "x-datadog-trace-id")) {
                DatadogAttributeParser.acceptJsonProperty(classifier, json, "x-datadog-parent-id");
                DatadogAttributeParser.acceptJsonProperty(classifier, json, "x-datadog-sampling-priority");
            }
            if (Config.get().isDataStreamsEnabled()) {
                DatadogAttributeParser.acceptJsonProperty(classifier, json, "dd-pathway-ctx-base64");
            }
        }
        catch (Exception e) {
            log.debug("Problem extracting _datadog context", e);
        }
    }

    public static void forEachProperty(AgentPropagation.KeyClassifier classifier, ByteBuffer json) {
        if (null == json) {
            return;
        }
        try {
            DatadogAttributeParser.forEachProperty(classifier, StandardCharsets.UTF_8.decode(BASE_64.decode(json)).toString());
        }
        catch (Exception e) {
            log.debug("Problem decoding _datadog context", e);
        }
    }

    private static boolean acceptJsonProperty(AgentPropagation.KeyClassifier classifier, String json, String key) {
        int valueEnd;
        int valueStart;
        int separator;
        int keyStart = json.indexOf(key);
        if (keyStart > 0 && (separator = json.indexOf(58, keyStart + key.length())) > 0 && (valueStart = json.indexOf(34, separator + 1)) > 0 && (valueEnd = json.indexOf(34, valueStart + 1)) > 0) {
            return classifier.accept(key, json.substring(valueStart + 1, valueEnd));
        }
        return false;
    }
}

