/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.function.Predicate;

public class MethodHandles {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.class);
    private final MethodHandles.Lookup lookup = java.lang.invoke.MethodHandles.lookup();
    private final ClassLoader classLoader;

    public MethodHandles(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MethodHandle privateFieldGetter(String className, String fieldName) {
        Class<?> clazz = this.loadClass(className);
        return clazz != null ? this.privateFieldGetter(clazz, fieldName) : null;
    }

    public MethodHandle privateFieldGetter(Class<?> clazz, String fieldName) {
        return AccessController.doPrivileged(() -> {
            try {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        String packageName = clazz.getPackage().getName();
                        sm.checkPackageAccess(packageName);
                    }
                }
                catch (UnsupportedOperationException sm) {
                    // empty catch block
                }
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return this.lookup.unreflectGetter(field);
            }
            catch (Throwable t) {
                log.debug("Could not get private field {} getter from class {}", fieldName, clazz.getName(), t);
                return null;
            }
        });
    }

    public MethodHandle privateFieldSetter(String className, String fieldName) {
        Class<?> clazz = this.loadClass(className);
        return clazz != null ? this.privateFieldSetter(clazz, fieldName) : null;
    }

    public MethodHandle privateFieldSetter(Class<?> clazz, String fieldName) {
        return AccessController.doPrivileged(() -> {
            try {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        String packageName = clazz.getPackage().getName();
                        sm.checkPackageAccess(packageName);
                    }
                }
                catch (UnsupportedOperationException sm) {
                    // empty catch block
                }
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return this.lookup.unreflectSetter(field);
            }
            catch (Throwable t) {
                log.debug("Could not get private field {} setter from class {}", fieldName, clazz.getName(), t);
                return null;
            }
        });
    }

    public MethodHandle constructor(String className, Class<?> ... parameterTypes) {
        Class<?> clazz = this.loadClass(className);
        return clazz != null ? this.constructor(clazz, parameterTypes) : null;
    }

    public MethodHandle constructor(Class<?> clazz, Class<?> ... parameterTypes) {
        return AccessController.doPrivileged(() -> {
            try {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        String packageName = clazz.getPackage().getName();
                        sm.checkPackageAccess(packageName);
                    }
                }
                catch (UnsupportedOperationException sm) {
                    // empty catch block
                }
                Constructor constructor = clazz.getDeclaredConstructor(parameterTypes);
                constructor.setAccessible(true);
                return this.lookup.unreflectConstructor(constructor);
            }
            catch (Throwable t) {
                log.debug("Could not get constructor accepting {} from class {}", Arrays.toString(parameterTypes), clazz.getName(), t);
                return null;
            }
        });
    }

    public MethodHandle method(String className, String methodName, Class<?> ... parameterTypes) {
        Class<?> clazz = this.loadClass(className);
        return clazz != null ? this.method(clazz, methodName, parameterTypes) : null;
    }

    public MethodHandle method(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return AccessController.doPrivileged(() -> {
            try {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        String packageName = clazz.getPackage().getName();
                        sm.checkPackageAccess(packageName);
                    }
                }
                catch (UnsupportedOperationException sm) {
                    // empty catch block
                }
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return this.lookup.unreflect(method);
            }
            catch (Throwable t) {
                log.debug("Could not get method {} accepting {} from class {}", methodName, Arrays.toString(parameterTypes), clazz, t);
                return null;
            }
        });
    }

    public MethodHandle method(Class<?> clazz, Predicate<Method> filter) {
        return AccessController.doPrivileged(() -> {
            try {
                Method[] methods;
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        String packageName = clazz.getPackage().getName();
                        sm.checkPackageAccess(packageName);
                    }
                }
                catch (UnsupportedOperationException sm) {
                    // empty catch block
                }
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (!filter.test(method)) continue;
                    method.setAccessible(true);
                    return this.lookup.unreflect(method);
                }
                log.debug("Could not find desired method in class {}", (Object)clazz);
                return null;
            }
            catch (Throwable t) {
                log.debug("Could not find desired method in class {}", (Object)clazz, (Object)t);
                return null;
            }
        });
    }

    private Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (Throwable t) {
            log.debug("Could not load class {}", (Object)className, (Object)t);
            return null;
        }
    }

    public <T> T invoke(MethodHandle handle, Object ... arguments) {
        if (handle == null) {
            return null;
        }
        try {
            return (T)handle.invokeWithArguments(arguments);
        }
        catch (Throwable t) {
            log.error("Error while invoking method handle {} with arguments {}", handle, Arrays.toString(arguments), t);
            return null;
        }
    }
}

