/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util.stacktrace;

import datadog.trace.util.stacktrace.StackWalker;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractStackWalker
implements StackWalker {
    @Override
    public <T> T walk(Function<Stream<StackTraceElement>, T> consumer) {
        return (T)this.doGetStack(input -> consumer.apply(this.doFilterStack((Stream<StackTraceElement>)input)));
    }

    final Stream<StackTraceElement> doFilterStack(Stream<StackTraceElement> stream) {
        return stream.filter(AbstractStackWalker::isNotDatadogTraceStackElement);
    }

    abstract <T> T doGetStack(Function<Stream<StackTraceElement>, T> var1);

    static boolean isNotDatadogTraceStackElement(StackTraceElement el) {
        String clazz = el.getClassName();
        return !clazz.startsWith("datadog.trace.") && !clazz.startsWith("com.datadog.iast.");
    }
}

