/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger.util;

import datadog.trace.bootstrap.debugger.CapturedContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class WellKnownClasses {
    private static Map<String, Function<Object, String>> toStringFinalSafeClasses = new HashMap<String, Function<Object, String>>();
    private static Map<String, Function<Object, String>> safeToStringFunctions;
    private static Set<String> stringPrimitives;
    private static Map<String, Function<Object, CapturedContext.CapturedValue>> specialFields;

    public static boolean isToStringFinalSafe(String type) {
        return toStringFinalSafeClasses.containsKey(type);
    }

    public static boolean isToStringSafe(String concreteType) {
        return safeToStringFunctions.containsKey(concreteType);
    }

    public static boolean isSizeSafe(Collection<?> collection) {
        String className = collection.getClass().getTypeName();
        return className.startsWith("java.");
    }

    public static boolean isSizeSafe(Map<?, ?> map) {
        String className = map.getClass().getTypeName();
        return className.startsWith("java.");
    }

    public static boolean isStringPrimitive(String type) {
        return stringPrimitives.contains(type);
    }

    public static Function<Object, CapturedContext.CapturedValue> getSpecialFieldAccess(String type) {
        return specialFields.get(type);
    }

    public static Function<Object, String> getSafeToString(String type) {
        return safeToStringFunctions.get(type);
    }

    private static CapturedContext.CapturedValue optionalSpecialField(Object o) {
        return CapturedContext.CapturedValue.of("value", Object.class.getTypeName(), ((Optional)o).orElse(null));
    }

    private static String classToString(Object o) {
        return ((Class)o).getTypeName();
    }

    private static String genericToString(Object o) {
        return String.valueOf(o);
    }

    static {
        toStringFinalSafeClasses.put("java.lang.Class", WellKnownClasses::classToString);
        toStringFinalSafeClasses.put("java.lang.String", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Boolean", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Integer", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Long", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Double", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Character", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Byte", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Float", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.lang.Short", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.math.BigDecimal", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.math.BigInteger", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.time.Duration", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.time.Instant", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.time.LocalTime", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.time.LocalDate", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.time.LocalDateTime", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.util.UUID", WellKnownClasses::genericToString);
        toStringFinalSafeClasses.put("java.net.URI", WellKnownClasses::genericToString);
        safeToStringFunctions = new HashMap<String, Function<Object, String>>();
        safeToStringFunctions.putAll(toStringFinalSafeClasses);
        safeToStringFunctions.put("java.util.concurrent.atomic.AtomicBoolean", WellKnownClasses::genericToString);
        safeToStringFunctions.put("java.util.concurrent.atomic.AtomicInteger", WellKnownClasses::genericToString);
        safeToStringFunctions.put("java.util.concurrent.atomic.AtomicLong", WellKnownClasses::genericToString);
        stringPrimitives = new HashSet<String>(Arrays.asList("java.lang.Class", "java.lang.String", "java.time.Duration", "java.time.Instant", "java.time.LocalTime", "java.time.LocalDate", "java.time.LocalDateTime", "java.util.UUID"));
        specialFields = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        specialFields.put("java.util.Optional", WellKnownClasses::optionalSpecialField);
    }
}

