/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.naming.SpanNaming;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.UriBasedClientDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HttpClientDecorator<REQUEST, RESPONSE>
extends UriBasedClientDecorator {
    public static final LinkedHashMap<String, String> CLIENT_PATHWAY_EDGE_TAGS = new LinkedHashMap(2);
    private static final Logger log;
    private static final BitSet CLIENT_ERROR_STATUSES;
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME;
    private static final boolean CLIENT_TAG_HEADERS;

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract int status(RESPONSE var1);

    protected abstract String getRequestHeader(REQUEST var1, String var2);

    protected abstract String getResponseHeader(RESPONSE var1, String var2);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_CLIENT;
    }

    @Override
    protected String service() {
        return null;
    }

    protected boolean shouldSetResourceName() {
        return true;
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            try {
                URI url = this.url(request);
                if (url != null) {
                    this.onURI(span, url);
                    span.setTag("http.url", URIUtils.lazyValidURL(url.getScheme(), url.getHost(), url.getPort(), url.getPath()));
                    if (Config.get().isHttpClientTagQueryString()) {
                        span.setTag("http.query.string", url.getQuery());
                        span.setTag("http.fragment.string", url.getFragment());
                    }
                    if (this.shouldSetResourceName()) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withClientPath(span, method, url.getPath());
                    }
                } else if (this.shouldSetResourceName()) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
            if (CLIENT_TAG_HEADERS) {
                for (Map.Entry<String, String> headerTag : AgentTracer.traceConfig(span).getRequestHeaderTags().entrySet()) {
                    String headerValue = this.getRequestHeader(request, headerTag.getKey());
                    if (null == headerValue) continue;
                    span.setTag(headerTag.getValue(), headerValue);
                }
            }
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            int status = this.status(response);
            if (status > 0) {
                span.setHttpStatusCode(status);
                if (CLIENT_ERROR_STATUSES.get(status)) {
                    span.setError(true);
                }
            }
            if (CLIENT_TAG_HEADERS) {
                for (Map.Entry<String, String> headerTag : AgentTracer.traceConfig(span).getResponseHeaderTags().entrySet()) {
                    String headerValue = this.getResponseHeader(response, headerTag.getKey());
                    if (null == headerValue) continue;
                    span.setTag(headerTag.getValue(), headerValue);
                }
            }
        }
        return span;
    }

    public String operationName() {
        return SpanNaming.instance().namingSchema().client().operationForComponent(this.component().toString());
    }

    public String getSpanTagAsString(AgentSpan span, String tag) {
        Object value = span.getTag(tag);
        return value == null ? null : value.toString();
    }

    public long getRequestContentLength(REQUEST request) {
        if (request == null) {
            return 0L;
        }
        String contentLengthStr = this.getRequestHeader(request, "Content-Length");
        if (contentLengthStr != null) {
            try {
                return Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long getResponseContentLength(RESPONSE response) {
        if (response == null) {
            return 0L;
        }
        String contentLengthStr = this.getResponseHeader(response, "Content-Length");
        if (contentLengthStr != null) {
            try {
                return Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    static {
        CLIENT_PATHWAY_EDGE_TAGS.put("direction", "out");
        CLIENT_PATHWAY_EDGE_TAGS.put("type", "http");
        log = LoggerFactory.getLogger(HttpClientDecorator.class);
        CLIENT_ERROR_STATUSES = Config.get().getHttpClientErrorStatuses();
        DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
        CLIENT_TAG_HEADERS = Config.get().isHttpClientTagHeaders();
    }
}

