/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.trace.api.git.PersonInfo;
import java.util.Objects;

public class CommitInfo {
    public static final CommitInfo NOOP = new CommitInfo(null, PersonInfo.NOOP, PersonInfo.NOOP, null);
    private final String sha;
    private final PersonInfo author;
    private final PersonInfo committer;
    private final String fullMessage;

    public CommitInfo(String sha) {
        this(sha, PersonInfo.NOOP, PersonInfo.NOOP, null);
    }

    public CommitInfo(String sha, PersonInfo author, PersonInfo committer, String fullMessage) {
        this.sha = sha;
        this.author = author;
        this.committer = committer;
        this.fullMessage = fullMessage;
    }

    public String getSha() {
        return this.sha;
    }

    public PersonInfo getAuthor() {
        return this.author;
    }

    public PersonInfo getCommitter() {
        return this.committer;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public boolean isEmpty() {
        return !(this.sha != null && !this.sha.isEmpty() || this.author != null && !this.author.isEmpty() || this.committer != null && !this.committer.isEmpty() || this.fullMessage != null && !this.fullMessage.isEmpty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitInfo that = (CommitInfo)o;
        return Objects.equals(this.sha, that.sha) && Objects.equals(this.author, that.author) && Objects.equals(this.committer, that.committer) && Objects.equals(this.fullMessage, that.fullMessage);
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + (this.sha == null ? 0 : this.sha.hashCode());
        hash = 31 * hash + (this.author == null ? 0 : this.author.hashCode());
        hash = 31 * hash + (this.committer == null ? 0 : this.committer.hashCode());
        hash = 31 * hash + (this.fullMessage == null ? 0 : this.fullMessage.hashCode());
        return hash;
    }

    public String toString() {
        return "CommitInfo{sha='" + this.sha + '\'' + ", author=" + this.author + ", committer=" + this.committer + ", fullMessage='" + this.fullMessage + '\'' + '}';
    }
}

