/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast;

import javax.annotation.Nullable;

public abstract class VulnerabilityTypes {
    public static final byte WEAK_CIPHER = 0;
    public static final byte WEAK_HASH = 1;
    public static final byte SQL_INJECTION = 2;
    public static final byte COMMAND_INJECTION = 3;
    public static final byte PATH_TRAVERSAL = 4;
    public static final byte LDAP_INJECTION = 5;
    public static final byte SSRF = 6;
    public static final byte INSECURE_COOKIE = 7;
    public static final byte NO_HTTPONLY_COOKIE = 8;
    public static final byte HSTS_HEADER_MISSING = 9;
    public static final byte XCONTENTTYPE_HEADER_MISSING = 10;
    public static final byte NO_SAMESITE_COOKIE = 11;
    public static final byte UNVALIDATED_REDIRECT = 12;
    public static final byte WEAK_RANDOMNESS = 13;
    public static final byte XPATH_INJECTION = 14;
    public static final byte TRUST_BOUNDARY_VIOLATION = 15;
    public static final byte XSS = 16;
    public static final byte STACKTRACE_LEAK = 17;
    public static final byte HEADER_INJECTION = 18;
    public static final byte VERB_TAMPERING = 19;
    public static final byte DEFAULT_HTML_ESCAPE_INVALID = 20;
    public static final byte SESSION_TIMEOUT = 21;
    public static final byte DIRECTORY_LISTING_LEAK = 22;
    public static final byte INSECURE_JSP_LAYOUT = 23;
    public static final byte ADMIN_CONSOLE_ACTIVE = 24;
    public static final byte HARDCODED_SECRET = 25;
    public static final byte INSECURE_AUTH_PROTOCOL = 26;
    public static final byte REFLECTION_INJECTION = 27;
    public static final byte SESSION_REWRITING = 28;
    public static final byte DEFAULT_APP_DEPLOYED = 29;
    public static final byte RESPONSE_HEADER = -128;
    public static final byte[] RESPONSE_HEADER_TYPES = new byte[]{12, 7, 11, 8, 10, 9, 18};
    public static final byte SPRING_RESPONSE = -127;
    public static final byte[] SPRING_RESPONSE_TYPES = new byte[]{12, 16};
    public static final byte APPLICATION = -126;
    public static final byte[] APPLICATION_TYPES = new byte[]{19, 24, 20, 21, 22, 23, 28, 29};
    public static final String[] STRINGS = new String[]{"WEAK_CIPHER", "WEAK_HASH", "SQL_INJECTION", "COMMAND_INJECTION", "PATH_TRAVERSAL", "LDAP_INJECTION", "SSRF", "INSECURE_COOKIE", "NO_HTTPONLY_COOKIE", "HSTS_HEADER_MISSING", "XCONTENTTYPE_HEADER_MISSING", "NO_SAMESITE_COOKIE", "UNVALIDATED_REDIRECT", "WEAK_RANDOMNESS", "XPATH_INJECTION", "TRUST_BOUNDARY_VIOLATION", "XSS", "STACKTRACE_LEAK", "HEADER_INJECTION", "VERB_TAMPERING", "DEFAULT_HTML_ESCAPE_INVALID", "SESSION_TIMEOUT", "DIRECTORY_LISTING_LEAK", "INSECURE_JSP_LAYOUT", "ADMIN_CONSOLE_ACTIVE", "HARDCODED_SECRET", "INSECURE_AUTH_PROTOCOL", "REFLECTION_INJECTION", "SESSION_REWRITING", "DEFAULT_APP_DEPLOYED"};

    private VulnerabilityTypes() {
    }

    public static String toString(byte vulnerability) {
        return vulnerability < 0 ? null : STRINGS[vulnerability];
    }

    @Nullable
    public static byte[] unwrap(byte vulnerability) {
        switch (vulnerability) {
            case -128: {
                return RESPONSE_HEADER_TYPES;
            }
            case -127: {
                return SPRING_RESPONSE_TYPES;
            }
            case -126: {
                return APPLICATION_TYPES;
            }
        }
        return null;
    }
}

