/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.naming.v0;

import datadog.trace.api.Config;
import datadog.trace.api.naming.NamingSchema;
import datadog.trace.api.remoteconfig.ServiceNameCollector;
import javax.annotation.Nonnull;

class MessagingNamingV0
implements NamingSchema.ForMessaging {
    private final boolean allowInferredServices;

    public MessagingNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @Nonnull
    public String outboundOperation(@Nonnull String messagingSystem) {
        if ("amqp".equals(messagingSystem)) {
            return "amqp.command";
        }
        return messagingSystem + ".produce";
    }

    @Override
    public String outboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return this.inboundService(messagingSystem, useLegacyTracing);
    }

    @Override
    @Nonnull
    public String inboundOperation(@Nonnull String messagingSystem) {
        switch (messagingSystem) {
            case "amqp": {
                return "amqp.command";
            }
            case "sqs": {
                return "aws.http";
            }
        }
        return messagingSystem + ".consume";
    }

    @Override
    public String inboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        if (this.allowInferredServices) {
            if (useLegacyTracing) {
                ServiceNameCollector.get().addService(messagingSystem);
                return messagingSystem;
            }
            return Config.get().getServiceName();
        }
        return null;
    }

    @Override
    @Nonnull
    public String timeInQueueService(@Nonnull String messagingSystem) {
        ServiceNameCollector.get().addService(messagingSystem);
        return messagingSystem;
    }

    @Override
    @Nonnull
    public String timeInQueueOperation(@Nonnull String messagingSystem) {
        if ("sqs".equals(messagingSystem)) {
            return "aws.http";
        }
        return messagingSystem + ".deliver";
    }
}

