/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.naming.NamingSchema;
import datadog.trace.api.naming.SpanNaming;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;
import java.util.function.BiConsumer;

public abstract class DatabaseClientDecorator<CONNECTION>
extends ClientDecorator {
    private static final DDCache<String, NamingEntry> CACHE = DDCaches.newFixedSizeCache(16);

    protected abstract String dbType();

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbInstance(CONNECTION var1);

    protected abstract CharSequence dbHostname(CONNECTION var1);

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        if (connection != null) {
            CharSequence hostName;
            span.setTag("db.user", this.dbUser(connection));
            String instanceName = this.dbInstance(connection);
            span.setTag("db.instance", instanceName);
            String serviceName = this.dbClientService(instanceName);
            if (null != serviceName) {
                span.setServiceName(serviceName);
            }
            if ((hostName = this.dbHostname(connection)) != null) {
                span.setTag("peer.hostname", hostName);
                if (Config.get().isDbClientSplitByHost()) {
                    span.setServiceName(hostName.toString());
                }
            }
        }
        return span;
    }

    public String dbService(String dbType, String instanceName) {
        if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
            return this.dbClientService(instanceName);
        }
        NamingEntry entry = CACHE.computeIfAbsent(dbType, x$0 -> new NamingEntry((String)x$0));
        return entry.getService();
    }

    public String dbClientService(String instanceName) {
        String service = null;
        if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
            service = Config.get().isDbClientSplitByInstanceTypeSuffix() ? instanceName + "-" + this.dbType() : instanceName;
        }
        return service;
    }

    public AgentSpan onStatement(AgentSpan span, CharSequence statement) {
        span.setResourceName(statement);
        return span;
    }

    public void onRawStatement(AgentSpan span, String sql) {
        RequestContext ctx;
        BiConsumer<RequestContext, String> sqlQueryCallback;
        if (Config.get().isAppSecRaspEnabled() && sql != null && !sql.isEmpty() && (sqlQueryCallback = AgentTracer.get().getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.databaseSqlQuery())) != null && (ctx = span.getRequestContext()) != null) {
            sqlQueryCallback.accept(ctx, sql);
        }
    }

    protected void processDatabaseType(AgentSpan span, String dbType) {
        RequestContext ctx;
        BiConsumer<RequestContext, String> connectDbCallback;
        NamingEntry namingEntry = CACHE.computeIfAbsent(dbType, x$0 -> new NamingEntry((String)x$0));
        span.setTag("db.type", namingEntry.dbType);
        this.postProcessServiceAndOperationName(span, namingEntry);
        if (Config.get().isAppSecRaspEnabled() && dbType != null && (connectDbCallback = AgentTracer.get().getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.databaseConnection())) != null && (ctx = span.getRequestContext()) != null) {
            connectDbCallback.accept(ctx, dbType);
        }
    }

    protected void postProcessServiceAndOperationName(AgentSpan span, NamingEntry namingEntry) {
    }

    protected static class NamingEntry {
        private final String service;
        private final CharSequence operation;
        private final String dbType;

        private NamingEntry(String rawDbType) {
            NamingSchema.ForDatabase schema = SpanNaming.instance().namingSchema().database();
            this.dbType = schema.normalizedName(rawDbType);
            this.service = schema.service(this.dbType);
            this.operation = UTF8BytesString.create(schema.operation(this.dbType));
        }

        public String getService() {
            return this.service;
        }

        public CharSequence getOperation() {
            return this.operation;
        }

        public String getDbType() {
            return this.dbType;
        }
    }
}

