/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.span_origin;

import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.span_origin.FindFirstStackTraceElement;
import datadog.trace.bootstrap.instrumentation.span_origin.LineInfo;
import datadog.trace.util.stacktrace.StackWalkerFactory;
import java.lang.reflect.Method;

public class EntrySpanOriginInfo {
    private static DDCache<String, EntrySpanOriginInfo> origins = DDCaches.newFixedSizeCache(256);
    public final LineInfo entry;

    public static void apply(Method method, AgentSpan span) {
        if (InstrumenterConfig.get().isSpanOriginEnabled()) {
            origins.computeIfAbsent(method.toString(), ignored -> new EntrySpanOriginInfo(method)).apply(span);
        }
    }

    public EntrySpanOriginInfo(Method method) {
        StackTraceElement element = StackWalkerFactory.INSTANCE.walk(new FindFirstStackTraceElement(method));
        this.entry = new LineInfo(method, element);
    }

    private void apply(AgentSpan span) {
        span.setTag("_dd.entry_location.file", this.entry.className);
        span.setTag("_dd.entry_location.method", this.entry.methodName);
        span.setTag("_dd.entry_location.line", this.entry.lineNumber);
        span.setTag("_dd.entry_location.signature", this.entry.signature);
    }
}

