/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import datadog.trace.bootstrap.instrumentation.api.SpanLink;
import datadog.trace.bootstrap.instrumentation.api.SpanLinkAttributes;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.shim.context.propagation.TraceStateHelper;
import java.util.List;

public class OtelSpanLink
extends SpanLink {
    public OtelSpanLink(SpanContext spanContext) {
        this(spanContext, Attributes.empty());
    }

    public OtelSpanLink(SpanContext spanContext, Attributes attributes) {
        super(DDTraceId.fromHex(spanContext.getTraceId()), DDSpanId.fromHex(spanContext.getSpanId()), spanContext.isSampled() ? (byte)1 : 0, TraceStateHelper.encodeHeader(spanContext.getTraceState()), OtelSpanLink.convertAttributes(attributes));
    }

    private static AgentSpanLink.Attributes convertAttributes(Attributes attributes) {
        if (attributes.isEmpty()) {
            return SpanLinkAttributes.EMPTY;
        }
        SpanLinkAttributes.Builder builder = SpanLinkAttributes.builder();
        attributes.forEach((attributeKey, value) -> {
            String key = attributeKey.getKey();
            switch (attributeKey.getType()) {
                case STRING: {
                    builder.put(key, (String)value);
                    break;
                }
                case BOOLEAN: {
                    builder.put(key, (Boolean)value);
                    break;
                }
                case LONG: {
                    builder.put(key, (Long)value);
                    break;
                }
                case DOUBLE: {
                    builder.put(key, (Double)value);
                    break;
                }
                case STRING_ARRAY: {
                    builder.putStringArray(key, (List)value);
                    break;
                }
                case BOOLEAN_ARRAY: {
                    builder.putBooleanArray(key, (List)value);
                    break;
                }
                case LONG_ARRAY: {
                    builder.putLongArray(key, (List)value);
                    break;
                }
                case DOUBLE_ARRAY: {
                    builder.putDoubleArray(key, (List)value);
                }
            }
        });
        return builder.build();
    }
}

