/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.util.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

final class OtelEnvironmentConfigSource
extends ConfigProvider.Source {
    private static final Logger log = LoggerFactory.getLogger(OtelEnvironmentConfigSource.class);
    private final boolean enabled;
    private final Map<String, String> otelEnvironment = new HashMap<String, String>();
    private final Properties otelConfigFile = OtelEnvironmentConfigSource.loadOtelConfigFile();
    private final Properties datadogConfigFile;

    @Override
    protected String get(String key) {
        if (!this.enabled) {
            return null;
        }
        String value = this.otelEnvironment.get(key);
        if (null == value && key.startsWith("otel.")) {
            value = this.getOtelProperty(key);
        }
        return value;
    }

    @Override
    public ConfigOrigin origin() {
        return ConfigOrigin.ENV;
    }

    OtelEnvironmentConfigSource() {
        this(null);
    }

    OtelEnvironmentConfigSource(Properties datadogConfigFile) {
        this.enabled = this.traceOtelEnabled();
        this.datadogConfigFile = datadogConfigFile;
        if (this.enabled) {
            this.setupOteEnvironment();
        }
    }

    private void setupOteEnvironment() {
        String sdkDisabled = this.getOtelProperty("otel.sdk.disabled", "dd.trace.otel.enabled");
        if ("true".equalsIgnoreCase(sdkDisabled)) {
            this.capture("trace.otel.enabled", "false");
            return;
        }
        String serviceName = this.getOtelProperty("otel.service.name", "dd.service.name");
        String logLevel = this.getOtelProperty("otel.log.level", "dd.log.level");
        String propagators = this.getOtelProperty("otel.propagators", "dd.trace.propagation.style");
        String tracesSampler = this.getOtelProperty("otel.traces.sampler", "dd.trace.sample.rate");
        String resourceAttributes = this.getOtelProperty("otel.resource.attributes", "dd.tags");
        String requestHeaders = this.getOtelHeaders("request-headers", "dd.trace.request_header.tags");
        String responseHeaders = this.getOtelHeaders("response-headers", "dd.trace.response_header.tags");
        String extensions = this.getOtelProperty("otel.javaagent.extensions", "dd.trace.extensions.path");
        if (null != resourceAttributes) {
            Map<String, String> attributeMap = OtelEnvironmentConfigSource.parseOtelMap(resourceAttributes);
            this.capture("service.name", attributeMap.remove("service.name"));
            this.capture("version", attributeMap.remove("service.version"));
            this.capture("env", attributeMap.remove("deployment.environment"));
            this.capture("tags", OtelEnvironmentConfigSource.renderDatadogMap(attributeMap, 10));
        }
        this.capture("log.level", logLevel);
        this.capture("service.name", serviceName);
        this.capture("trace.propagation.style", OtelEnvironmentConfigSource.mapPropagationStyle(propagators));
        this.capture("trace.sample.rate", this.mapSampleRate(tracesSampler));
        this.capture("trace.enabled", this.mapDataCollection("traces"));
        this.capture("runtime.metrics.enabled", this.mapDataCollection("metrics"));
        this.mapDataCollection("logs");
        this.capture("trace.request_header.tags", OtelEnvironmentConfigSource.mapHeaderTags("http.request.header.", requestHeaders));
        this.capture("trace.response_header.tags", OtelEnvironmentConfigSource.mapHeaderTags("http.response.header.", responseHeaders));
        this.capture("trace.extensions.path", extensions);
    }

    private boolean traceOtelEnabled() {
        String enabled = this.getDatadogProperty("dd.trace.otel.enabled");
        if (null != enabled) {
            return Boolean.parseBoolean(enabled);
        }
        return false;
    }

    private String getOtelProperty(String otelSysProp, String ddSysProp) {
        String otelValue = this.getOtelProperty(otelSysProp);
        if (null == otelValue) {
            return null;
        }
        String ddValue = this.getDatadogProperty(ddSysProp);
        if (null != ddValue) {
            String otelEnvVar = Strings.toEnvVar(otelSysProp);
            log.warn("Both {} and {} are set, ignoring {}", Strings.toEnvVar(ddSysProp), otelEnvVar, otelEnvVar);
            return null;
        }
        return otelValue;
    }

    private String getOtelProperty(String sysProp) {
        String value = OtelEnvironmentConfigSource.getProperty(sysProp);
        if (null == value && null != this.otelConfigFile) {
            value = this.otelConfigFile.getProperty(sysProp);
        }
        return value;
    }

    private String getDatadogProperty(String sysProp) {
        String value = OtelEnvironmentConfigSource.getProperty(sysProp);
        if (null == value && null != this.datadogConfigFile) {
            value = this.datadogConfigFile.getProperty(sysProp);
        }
        return value;
    }

    private static String getProperty(String sysProp) {
        String value = System.getProperty(sysProp);
        if (null == value) {
            value = System.getenv(Strings.toEnvVar(sysProp));
        }
        return value;
    }

    private void capture(String key, String value) {
        if (null != value) {
            this.otelEnvironment.put(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadOtelConfigFile() {
        File file;
        String path = OtelEnvironmentConfigSource.getProperty("otel.javaagent.configuration-file");
        if (null == path) return null;
        if (path.isEmpty()) return null;
        if (path.charAt(0) == '~') {
            path = System.getProperty("user.home") + path.substring(1);
        }
        if (!(file = new File(path)).exists()) return null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Properties properties2 = new Properties();
            properties2.load(in);
            Properties properties = properties2;
            return properties;
        }
        catch (Throwable e) {
            log.warn("Problem reading OTEL_JAVAAGENT_CONFIGURATION_FILE {} - {}", (Object)path, (Object)e.toString());
        }
        return null;
    }

    private static List<String> parseOtelList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        while (start < value.length()) {
            int end = value.indexOf(44, start);
            if (end < 0) {
                end = value.length();
            }
            if (end > start) {
                list.add(value.substring(start, end));
            }
            start = end + 1;
        }
        return list;
    }

    private static Map<String, String> parseOtelMap(String value) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int start = 0;
        while (start < value.length()) {
            String entry;
            int eq;
            int end = value.indexOf(44, start);
            if (end < 0) {
                end = value.length();
            }
            if (end > start && (eq = (entry = value.substring(start, end)).indexOf(61)) > 0) {
                map.put(entry.substring(0, eq), entry.substring(eq + 1));
            }
            start = end + 1;
        }
        return map;
    }

    private static String renderDatadogMap(Map<String, String> map, int maxEntries) {
        StringBuilder buf = new StringBuilder();
        int entries = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buf.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
            if (++entries < maxEntries) continue;
            break;
        }
        return buf.length() > 1 ? buf.substring(0, buf.length() - 1) : null;
    }

    private static String mapPropagationStyle(String propagators) {
        if (null == propagators) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (String style : OtelEnvironmentConfigSource.parseOtelList(propagators)) {
            if ("b3".equalsIgnoreCase(style)) {
                buf.append("b3single,");
                continue;
            }
            try {
                buf.append((Object)TracePropagationStyle.valueOfDisplayName(style)).append(',');
            }
            catch (IllegalArgumentException e) {
                log.warn("OTEL_PROPAGATORS={} is not supported", (Object)style);
            }
        }
        return buf.length() > 1 ? buf.substring(0, buf.length() - 1) : null;
    }

    private String mapSampleRate(String tracesSampler) {
        if (null == tracesSampler) {
            return null;
        }
        if ("traceidratio".equalsIgnoreCase(tracesSampler) || "always_on".equalsIgnoreCase(tracesSampler) || "always_off".equalsIgnoreCase(tracesSampler)) {
            log.warn("OTEL_TRACES_SAMPLER changed from {} to parentbased_{}; only parent based sampling is supported.", (Object)tracesSampler, (Object)tracesSampler);
            tracesSampler = "parentbased_" + tracesSampler;
        }
        if ("parentbased_traceidratio".equalsIgnoreCase(tracesSampler)) {
            return this.getOtelProperty("otel.traces.sampler.arg");
        }
        if ("parentbased_always_on".equalsIgnoreCase(tracesSampler)) {
            return "1.0";
        }
        if ("parentbased_always_off".equalsIgnoreCase(tracesSampler)) {
            return "0.0";
        }
        log.warn("OTEL_TRACES_SAMPLER={} is not supported", (Object)tracesSampler);
        return null;
    }

    private String mapDataCollection(String type) {
        String exporter = this.getOtelProperty("otel." + type + ".exporter");
        if (null == exporter) {
            return null;
        }
        if ("none".equalsIgnoreCase(exporter)) {
            return "false";
        }
        log.warn("OTEL_{}_EXPORTER={} is not supported", (Object)type, (Object)exporter.toUpperCase(Locale.ROOT));
        return null;
    }

    private String getOtelHeaders(String otelSuffix, String ddSysProp) {
        String clientTags = this.getOtelProperty("otel.instrumentation.http.client.capture-" + otelSuffix, ddSysProp);
        String serverTags = this.getOtelProperty("otel.instrumentation.http.server.capture-" + otelSuffix, ddSysProp);
        if (null == clientTags) {
            return serverTags;
        }
        if (null == serverTags) {
            return clientTags;
        }
        return clientTags + ',' + serverTags;
    }

    private static String mapHeaderTags(String tagPrefix, String headers) {
        if (null == headers) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (String header : OtelEnvironmentConfigSource.parseOtelList(headers)) {
            buf.append(header).append(':').append(tagPrefix).append(header).append(',');
        }
        return buf.length() > 1 ? buf.substring(0, buf.length() - 1) : null;
    }
}

