/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger.spanorigin;

import datadog.trace.api.InstrumenterConfig;
import datadog.trace.bootstrap.debugger.DebuggerContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public class SpanOriginInfo {
    public static void entry(AgentSpan span, Method method) {
        if (InstrumenterConfig.get().isSpanOriginEnabled()) {
            String signature = Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",", "(", ")"));
            DebuggerContext.captureSnapshot(signature);
        }
    }

    public static void exit(AgentSpan span) {
        if (InstrumenterConfig.get().isSpanOriginEnabled()) {
            span.getLocalRootSpan().setMetaStruct(DebuggerContext.captureSnapshot(null), span);
        }
    }
}

