/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util.stacktrace;

import datadog.trace.api.Platform;
import datadog.trace.util.stacktrace.AbstractStackWalker;
import datadog.trace.util.stacktrace.HotSpotStackTraceIterator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class HotSpotStackWalker
extends AbstractStackWalker {
    JavaLangAccess access;

    HotSpotStackWalker() {
        try {
            this.access = SharedSecrets.getJavaLangAccess();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            if (Platform.isJavaVersion(8) && this.access != null) {
                this.access.getStackTraceElement(new Throwable(), 0);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    <T> T doGetStack(Function<Stream<StackTraceElement>, T> consumer) {
        Throwable throwable = new Throwable();
        Iterable iterable = () -> new HotSpotStackTraceIterator(throwable, this.access);
        return consumer.apply(StreamSupport.stream(iterable.spliterator(), false));
    }
}

